import glob
import os
import sys
import shutil

from setuptools import setup

from distutils.command.install_lib import install_lib


def locate_dylib(target_dir):
    if sys.platform == "win32":
        wildcard_so = "*.dll"
    else:
        wildcard_so = "*.so"

    return glob.glob(os.path.join(target_dir, wildcard_so))[0]


class install_lib_mine(install_lib):
    def build(self):
        install_lib.build(self)

        target_dir = '.'
        try:
            # Ask build_ext where the shared library would go if it had built it
            dylib_path = locate_dylib('.')
        except IndexError:
            raise Exception("build failed; unable to find any .dylib in %s" %
                            target_dir)

        # then copy it there.
        self.install_dylib(dylib_path)

    def install_dylib(self, dylib_path):
        build_ext = self.get_finalized_command('build_ext')
        target_fname = os.path.splitext(os.path.basename(dylib_path))[0]
        ext_path = build_ext.get_ext_fullpath(os.path.basename(target_fname))
        try:
            os.makedirs(os.path.dirname(ext_path))
        except OSError:
            pass
        shutil.copyfile(dylib_path, ext_path)


if __name__ == "__main__":
    setup(
        name='pyneh',
        version='0.1.0',
        cmdclass={
            'install_lib': install_lib_mine
        },
        packages=[],
        zip_safe=False
    )
