#pragma once

#include "const.h"

#include <util/generic/cast.h>

namespace NYasmServer {

    template <class T, class F>
    inline TAtomicSharedPtr<T> DynamicPointerCast(const TAtomicSharedPtr<F>& ptr) {
        auto val = VerifyDynamicCast<T*, F*>(ptr.Get());
        ptr.ReferenceCounter()->Inc();
        return TAtomicSharedPtr<T>(val, ptr.ReferenceCounter());
    }

} // namespace NYasmServer
