#include <infra/yasm/server/common/helpers.h>
#include <infra/yasm/zoom/components/compression/bit_stream.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/datetime/base.h>

using namespace NYasmServer;

template <ui64 size>
inline static void BenchmarkBitStreamWriting(NBench::NCpu::TParams& iface) {
    TString stream;
    // allocate 512 bits
    stream.reserve(64);

    ui32 position = 0;
    for (size_t i = 0; i < iface.Iterations(); i++) {
        AddToBitStream(1, size, stream, position);
        // wrap around a bit earlier to avoid reallocations
        position %= 256;
    }
}

Y_CPU_BENCHMARK(BitStream_Writing_SingleBit, iface) {
    BenchmarkBitStreamWriting<1>(iface);
}

Y_CPU_BENCHMARK(BitStream_Writing_ThreeBits, iface) {
    BenchmarkBitStreamWriting<3>(iface);
}

Y_CPU_BENCHMARK(BitStream_Writing_ManyBytes, iface) {
    BenchmarkBitStreamWriting<64>(iface);
}

template <ui64 size>
inline static void BenchmarkBitStreamReading(NBench::NCpu::TParams& iface) {
    TString stream{64, (char)255};
    size_t position = 0;
    for (size_t i = 0; i < iface.Iterations(); i++) {
        Y_DO_NOT_OPTIMIZE_AWAY(ReadFromBitStream(stream, position, size));
        position %= 256;
    }
}

Y_CPU_BENCHMARK(BitStream_Reading_SingleBit, iface) {
    BenchmarkBitStreamReading<1>(iface);
}

Y_CPU_BENCHMARK(BitStream_Reading_ThreeBits, iface) {
    BenchmarkBitStreamReading<3>(iface);
}

Y_CPU_BENCHMARK(BitStream_Reading_TwoBytes, iface) {
    BenchmarkBitStreamReading<16>(iface);
}

Y_CPU_BENCHMARK(BitStream_Reading_EightBytes, iface) {
    BenchmarkBitStreamReading<64>(iface);
}

Y_CPU_BENCHMARK(BitStream_Reading_Aligned, iface) {
    TString stream{64, (char)255};
    for (size_t i = 0; i < iface.Iterations(); i++) {
        size_t position = 0;
        Y_DO_NOT_OPTIMIZE_AWAY(AlignedReadFromBitStreamUncompressed<ui64>(stream, position));
    }
}
