#include <infra/yasm/server/lib/storage/counted_sum_list.h>

#include <infra/yasm/server/common/helpers.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/datetime/base.h>

using namespace NYasmServer;
using namespace NYasm::NCommon::NInterval;

Y_CPU_BENCHMARK(CountedSumList_Writing, iface) {
    TCountedSumList storage;
    auto start = GetCurrentIterationStart();

    for (size_t i = 0; i < iface.Iterations(); i++) {
        // sum very rarely changes in practice
        auto value = storage.PushValue(start + ITERATION_SIZE * i, TCountedSum(1, (double)i));
        Y_DO_NOT_OPTIMIZE_AWAY(value);
    }
}

static void FillCountedSumList(TCountedSumList& storage, TInstant start) {
    auto count = FRESH_DURATION / ITERATION_SIZE;
    for (size_t i = 0; i < count; i++) {
        storage.PushValue(start + ITERATION_SIZE * i, TCountedSum(15, (double)i));
    }
}

Y_CPU_BENCHMARK(CountedSumList_ReadingOldest, iface) {
    TCountedSumList storage;
    auto start = GetCurrentIterationStart();
    FillCountedSumList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}

Y_CPU_BENCHMARK(CountedSumList_ReadingMiddle, iface) {
    TCountedSumList storage;
    auto start = GetCurrentIterationStart();
    FillCountedSumList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start + FRESH_DURATION / 2);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}

Y_CPU_BENCHMARK(CountedSumList_ReadingNewest, iface) {
    TCountedSumList storage;
    auto start = GetCurrentIterationStart();
    FillCountedSumList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start + FRESH_DURATION - ITERATION_SIZE);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}
