#include <infra/yasm/server/lib/storage/float_list.h>

#include <infra/yasm/common/interval.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/datetime/base.h>

using namespace NYasmServer;
using namespace NYasm::NCommon::NInterval;

Y_CPU_BENCHMARK(FloatList_Writing, iface) {
    TFloatList storage;
    auto start = GetCurrentIterationStart();

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.PushValue(start + ITERATION_SIZE * i, (double)i);
        Y_DO_NOT_OPTIMIZE_AWAY(value);
    }
}

static void FillFloatList(TFloatList& storage, TInstant start) {
    auto count = FRESH_DURATION / ITERATION_SIZE;
    for (size_t i = 0; i < count; i++) {
        storage.PushValue(start + ITERATION_SIZE * i, (double)i);
    }
}

Y_CPU_BENCHMARK(FloatList_ReadingOldest, iface) {
    TFloatList storage;
    auto start = GetCurrentIterationStart();
    FillFloatList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}

Y_CPU_BENCHMARK(FloatList_ReadingMiddle, iface) {
    TFloatList storage;
    auto start = GetCurrentIterationStart();
    FillFloatList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start + FRESH_DURATION / 2);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}

Y_CPU_BENCHMARK(FloatList_ReadingNewest, iface) {
    TFloatList storage;
    auto start = GetCurrentIterationStart();
    FillFloatList(storage, start);

    for (size_t i = 0; i < iface.Iterations(); i++) {
        auto value = storage.GetValueAt(start + FRESH_DURATION - ITERATION_SIZE);
        Y_DO_NOT_OPTIMIZE_AWAY(value.Defined());
    }
}
