#pragma once

#include "storage/fresh.h"

#include <infra/yasm/common/labels/tags/request_key.h>
#include <infra/yasm/common/labels/tags/dynamic_filter.h>
#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/common/labels/host/host.h>

#include <util/datetime/base.h>

namespace NYasmServer {
    struct TAggregatedSeries {
        TAggregatedSeries(NZoom::NHost::THostName host,
                          TInstant timestamp,
                          const NTags::TRequestKey& requestKey,
                          THashMap<NZoom::NSignal::TSignalName, NZoom::NValue::TValue>&& signalsData,
                          size_t matchedInstances)
            : Host(host)
            , Timestamp(timestamp)
            , RequestKey(requestKey)
            , SignalsData(std::move(signalsData))
            , MatchedInstances(matchedInstances)
        {
        }

        NZoom::NHost::THostName Host;
        TInstant Timestamp;
        const NTags::TRequestKey& RequestKey;
        THashMap<NZoom::NSignal::TSignalName, NZoom::NValue::TValue> SignalsData;
        size_t MatchedInstances;
    };

    struct TTagSignal {
        TTagSignal(NTags::TRequestKey&& requestKey, TVector<NZoom::NSignal::TSignalName>&& signals)
            : RequestKey(std::move(requestKey))
            , Signals(std::move(signals))
        {
        }

        NTags::TRequestKey RequestKey;
        TVector<NZoom::NSignal::TSignalName> Signals;
    };

    std::pair<TVector<TAggregatedSeries>, size_t> LoadAggregatedData(const TFreshStorage& fresh,
                                                                     const TVector<NZoom::NHost::THostName>& hosts,
                                                                     const TVector<TTagSignal>& tags,
                                                                     const TInstant start,
                                                                     const TInstant end);
}
