#pragma once

#include <util/generic/string.h>

namespace NYasmServer {
    namespace NMetrics {
        const TString FRESH_CLEANUP_TIME = "fresh.cleanup_time";
        const TString FRESH_LOADING_TIME = "fresh.loading_time";
        const TString FRESH_SERIES_COUNT = "fresh.series_count";
        const TString FRESH_TAGS_COUNT = "fresh.tags_count";

        const TString GROUPS_INDEX_SIZE = "fresh.groups_index.size";
        const TString GROUPS_INDEX_CLEANUP_TIME = "fresh.groups_index.cleanup_time";

        const TString FETCH_HOSTS_RESPONSE_TIME = "handlers.fetch_hosts.response_time";
        const TString FETCH_DATA_RESPONSE_TIME = "handlers.fetch_aggregated_data.response_time";
        const TString FETCH_DATA_SERIES_READ = "handlers.fetch_aggregated_data.series_read";

        const TString GROUP_SMALL_HGRAMS = "handlers.group_small_hgrams_accepted";
        const TString GROUP_HGRAMS = "handlers.group_hgrams_accepted";
        const TString HOST_SMALL_HGRAMS = "handlers.host_small_hgrams_accepted";
        const TString HOST_HGRAMS = "handlers.host_hgrams_accepted";

        const TString PUSH_SIGNALS_RESPONSE_TIME = "handlers.push_signals.response_time";
        const TString PUSH_SIGNALS_USELESS_WRITES_COUNT = "handlers.push_signals.useless_writes";
        const TString PUSH_SIGNALS_USEFUL_WRITES_COUNT = "handlers.push_signals.useful_writes";
        const TString PUSH_SIGNALS_EMPTY_TAGS_COUNT = "handlers.push_signals.empty_tags";
        const TString PUSH_SIGNALS_EMPTY_SIGNALS_COUNT = "handlers.push_signals.empty_signals";
        const TString PUSH_SIGNALS_ACCEPTED_VALUES_COUNT = "handlers.push_signals.accepted_values";
        const TString PUSH_SIGNALS_IGNORED_VALUES_COUNT = "handlers.push_signals.ignored_values";
        const TString PUSH_SIGNALS_REQUEST_SIZE = "handlers.push_signals.request_size";

        const TString READ_AGGREGATED_RESPONSE_TIME = "handlers.read_aggregated.response_time";
        const TString READ_AGGREGATED_SERIES_READ = "handlers.read_aggregated.series_read";

        const TString SNAPSHOTTER_ITERATION_TIME = "snapshotter.iteration_time";
        const TString SNAPSHOTTER_SUBMITTED_CHUNKS_COUNT = "snapshotter.submitted_chunks_count";
        const TString SNAPSHOTTER_SNAPSHOT_SIZE_CHUNKS = "snapshotter.snapshot_size.chunks";
        const TString SNAPSHOTTER_SNAPSHOT_SIZE_BYTES = "snapshotter.snapshot_size.bytes";
        const TString SNAPSHOTTER_REMOVED_FILES_COUNT = "snapshotter.removed_files_count";

        const TString LIST_ALL_SIGNALS_RESPONSE_TIME = "handlers.list_all_signals.response_time";
    } // namespace NMetrics
} // namespace NYasmServer
