#pragma once

#include <infra/monitoring/common/msgpack.h>

#include <library/cpp/json/json_value.h>

#include <util/generic/maybe.h>

namespace NYasmServer {
    using NMonitoring::EnsureIs;
    using NMonitoring::PackString;
    using NMonitoring::TArrayIterator;
    using NMonitoring::TMapIterator;

    inline TMaybe<msgpack::object> FindByKey(msgpack::object_map map, TStringBuf key) {
        for (const auto& pair : TMapIterator(map)) {
            if (pair.key.as<TStringBuf>() == key) {
                return pair.val;
            }
        }
        ythrow yexception() << key << " is missing";
    }

    inline const msgpack::object_array& SafeArray(const msgpack::object& val) {
        EnsureIs(val, msgpack::type::ARRAY);
        return val.via.array;
    }

    template <class T, class TContainer>
    inline void PackArray(msgpack::packer<T>& packer, const TContainer& data) {
        packer.pack_array(data.size());
        for (const auto& item : data) {
            PackString(packer, item);
        }
    }

    TString JsonToMsgpack(const TString& json);

    NJson::TJsonValue MsgpackToJson(const msgpack::object& val);
    NJson::TJsonValue MsgpackToJson(const TString& data);
} // namespace NYasmServer
