#pragma once

#include "metrics.h"
#include "storage/fresh.h"

#include <infra/monitoring/common/proto_replier.h>
#include <infra/yasm/interfaces/internal/tsdb.pb.h>
#include <infra/yasm/interfaces/internal/history_api.pb.h>

namespace NYasmServer {
    class TPushSignalsProtobufHandler final : public NMonitoring::TAbstractProtoReplier<
            NYasm::NInterfaces::NInternal::TTsdbPushSignalRequest,
            NYasm::NInterfaces::NInternal::TTsdbPushSignalResponse> {
    public:
        TPushSignalsProtobufHandler(TFreshStorage& fresh, TLog& logger)
            : Fresh(fresh)
            , Logger(logger)
        {
        }

        const TString& GetTimingMetricName() const override {
            return NMetrics::PUSH_SIGNALS_RESPONSE_TIME;
        }

        const TString& GetHandleName() const override {
            return NMetrics::PUSH_SIGNALS_RESPONSE_TIME;
        }

        TLog& GetLogger() override {
            return Logger;
        }

        void Handle(TProtoContext& context) override;

    private:
        TFreshStorage& Fresh;
        TLog& Logger;
    };

    class TReadAggregatedProtobufHandler final : public NMonitoring::TAbstractProtoReplier<
            NYasm::NInterfaces::NInternal::THistoryReadAggregatedRequest,
            NYasm::NInterfaces::NInternal::THistoryReadAggregatedResponse> {
    public:
        TReadAggregatedProtobufHandler(TFreshStorage& fresh, TLog& logger)
            : Fresh(fresh)
            , Logger(logger)
        {
        }

        const TString& GetTimingMetricName() const override {
            return NMetrics::READ_AGGREGATED_RESPONSE_TIME;
        }

        const TString& GetHandleName() const override {
            return NMetrics::READ_AGGREGATED_RESPONSE_TIME;
        }

        TLog& GetLogger() override {
            return Logger;
        }

        void Handle(TProtoContext& context) override;

    private:
        TFreshStorage& Fresh;
        TLog& Logger;
    };
}
