#pragma once

#include <infra/monitoring/common/periodic_task.h>

#include <library/cpp/logger/log.h>

namespace NYasmServer {

/**
 * Performs periodic system metrics reporting to solomon: e.g. RSS, CPU load.
 */

class TServerMonitoring {
public:
    explicit TServerMonitoring(TLog& logger);

    void Start();
    void ShutDown();

private:
    void ReportProcessMetrics();

private:
    TLog& Logger_;
    NMonitoring::TPeriodicTaskPtr MonitoringJob_;
};

} // namespace NYasmServer
