#include "counters.h"
#include "record_list.h"

using namespace NYasmServer;

TLastDumpTimeFinder::TLastDumpTimeFinder(TInstant baseline, size_t capacity)
    : Baseline(baseline)
{
    UnderdoneCounters.resize(capacity);
}

TLastDumpTimeFinder TLastDumpTimeFinder::CreateForFresh(TInstant now) {
    now = NYasm::NCommon::NInterval::NormalizeToIntervalUp(now, CHUNK_SIZE);
    TInstant baseline = now - FRESH_DURATION * 2;
    size_t capacity = (now - baseline).GetValue() / CHUNK_SIZE.GetValue() + 1;
    return TLastDumpTimeFinder(baseline, capacity);
}

TMaybe<TInstant> TLastDumpTimeFinder::GetTimestamp() const {
    TInstant timestamp(Baseline);
    TInstant maxTimestamp(TInstant::Zero());
    for (const auto& wrapper : UnderdoneCounters) {
        if (AtomicGet(wrapper.Seen)) {
            if (AtomicGet(wrapper.Counter) > 0) {
                // we should rewrite first incomplete chunk
                break;
            } else {
                maxTimestamp = timestamp;
            }
        }
        timestamp += CHUNK_SIZE;
    }
    return (maxTimestamp != TInstant::Zero()) ? MakeMaybe(maxTimestamp) : Nothing();
}

TAtomic* TLastDumpTimeFinder::GetCounter(TInstant timestamp) {
    timestamp = NYasm::NCommon::NInterval::NormalizeToIntervalDown(timestamp, CHUNK_SIZE);
    if (timestamp < Baseline) {
        return nullptr;
    }
    size_t position = (timestamp - Baseline).GetValue() / CHUNK_SIZE.GetValue();
    if (position >= UnderdoneCounters.size()) {
        return nullptr;
    }
    auto& wrapper(UnderdoneCounters[position]);
    AtomicSet(wrapper.Seen, 1);
    return &wrapper.Counter;
}
