#pragma once

#include <infra/yasm/server/common/helpers.h>

#include <library/cpp/deprecated/atomic/atomic.h>

#include <util/generic/vector.h>
#include <util/generic/maybe.h>

namespace NYasmServer {
    class TLastDumpTimeFinder {
    public:
        TLastDumpTimeFinder(TInstant baseline, size_t capacity);

        static TLastDumpTimeFinder CreateForFresh(TInstant now);

        bool AddFinished(TInstant timestamp) {
            return GetCounter(timestamp) != nullptr;
        }

        bool AddIncomplete(TInstant timestamp) {
            auto* counter(GetCounter(timestamp));
            if (counter != nullptr) {
                AtomicIncrement(*counter);
                return true;
            } else {
                return false;
            }
        }

        TMaybe<TInstant> GetTimestamp() const;

    private:
        struct TAtomicWrapper {
            TAtomicWrapper()
                : Seen(0)
                , Counter(0)
            {
            }

            TAtomic Seen;
            TAtomic Counter;
        };

        TAtomic* GetCounter(TInstant timestamp);

        TInstant Baseline;
        TVector<TAtomicWrapper> UnderdoneCounters;
    };
}
