#include "counters.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NYasmServer;

Y_UNIT_TEST_SUITE(TestLastDumpTimeFinder) {

    Y_UNIT_TEST(TestWithoutUnderdone) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642773)));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), Nothing());
        finder.AddFinished(TInstant::Seconds(1545642000));
        finder.AddFinished(TInstant::Seconds(1545642300));
        finder.AddFinished(TInstant::Seconds(1545642600));
        finder.AddFinished(TInstant::Seconds(1545642900));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), MakeMaybe(TInstant::Seconds(1545642900)));
    }

    Y_UNIT_TEST(TestWithOneUnderdoneAtTheEnd) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642900)));
        finder.AddFinished(TInstant::Seconds(1545642000));
        finder.AddFinished(TInstant::Seconds(1545642600));
        finder.AddIncomplete(TInstant::Seconds(1545642600));
        finder.AddFinished(TInstant::Seconds(1545642900));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), MakeMaybe(TInstant::Seconds(1545642000)));
    }

    Y_UNIT_TEST(TestWithOneUnderdoneInTheMiddle) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642900)));
        finder.AddFinished(TInstant::Seconds(1545642000));
        finder.AddIncomplete(TInstant::Seconds(1545642600));
        finder.AddFinished(TInstant::Seconds(1545642600));
        finder.AddFinished(TInstant::Seconds(1545642900));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), MakeMaybe(TInstant::Seconds(1545642000)));
    }

    Y_UNIT_TEST(TestWithMultipleUnderdone) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642900)));
        finder.AddFinished(TInstant::Seconds(1545642000));
        finder.AddIncomplete(TInstant::Seconds(1545642300));
        finder.AddFinished(TInstant::Seconds(1545642300));
        finder.AddFinished(TInstant::Seconds(1545642600));
        finder.AddIncomplete(TInstant::Seconds(1545642900));
        finder.AddFinished(TInstant::Seconds(1545642900));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), MakeMaybe(TInstant::Seconds(1545642000)));
    }

    Y_UNIT_TEST(TestOutOfRange) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642900)));
        UNIT_ASSERT(!finder.AddFinished(TInstant::Seconds(1545639000)));
        UNIT_ASSERT(finder.AddFinished(TInstant::Seconds(1545639300)));
        UNIT_ASSERT(finder.AddFinished(TInstant::Seconds(1545642900)));
        UNIT_ASSERT(!finder.AddFinished(TInstant::Seconds(1545643200)));
    }

    Y_UNIT_TEST(TestEmpty) {
        auto finder(TLastDumpTimeFinder::CreateForFresh(TInstant::Seconds(1545642900)));
        UNIT_ASSERT(!finder.AddFinished(TInstant::Seconds(1545639000)));
        UNIT_ASSERT_VALUES_EQUAL(finder.GetTimestamp(), Nothing());
    }

}
