#include "host_index.h"

#include <library/cpp/testing/unittest/gtest.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NYasmServer {

    Y_UNIT_TEST_SUITE(TestHostIndex) {
        Y_UNIT_TEST(TestSimpleEmplace) {
            THostIndex index;
            auto now = TInstant::Now();
            index.Emplace(TStringBuf("group1"), {{TStringBuf("host1"), now}, {TStringBuf("host2"), now}});
            index.Emplace(TStringBuf("group1"), {{TStringBuf("host2"), now}}); // already existing host
            index.Emplace(TStringBuf("group2"), {{TStringBuf("host3"), now}}); // other group

            auto result = index.GetHostsInGroup(TStringBuf("group1"));
            UNIT_ASSERT_EQUAL_C(result.size(), 2, result.size());
        }
        Y_UNIT_TEST(TestBatchEmplace) {
            THostIndex index;
            auto now = TInstant::Now();
            index.Emplace(TStringBuf("group1"), {{TStringBuf("host1"), now}, {TStringBuf("host2"), now}, {TStringBuf("host3"), now}});
            auto result = index.GetHostsInGroup(TStringBuf("group1"));
            UNIT_ASSERT_EQUAL_C(result.size(), 3, result.size());
        }

        Y_UNIT_TEST(TestEmptyGroup) {
            THostIndex index;
            auto result = index.GetHostsInGroup(TStringBuf("missing"));
            UNIT_ASSERT_EQUAL_C(result.size(), 0, result.size());
        }

        Y_UNIT_TEST(TestCleanup) {
            auto now = TInstant::Now();
            auto past = now - TDuration::Minutes(30);

            THostIndex index;

            index.Emplace(TStringBuf("group1"), {{TStringBuf("host1"), past}, {TStringBuf("host2"), now}});
            index.Emplace(TStringBuf("group2"), {{TStringBuf("host1"), past}, {TStringBuf("host2"), past}});
            index.Cleanup(now - TDuration::Minutes(5));

            auto result = index.GetHostsInGroup(TStringBuf("group2"));
            UNIT_ASSERT_EQUAL_C(result.size(), 0, result.size());

            result = index.GetHostsInGroup(TStringBuf("group1"));
            UNIT_ASSERT_EQUAL_C(result.size(), 1, result.size());
        }
    }
} // namespace NYasmServer
