#pragma once

#include <infra/monitoring/common/settings.h>

#include <util/generic/hash_set.h>
#include <util/generic/string.h>

namespace NYasmServer {

    class TTsdbSettings : public NMonitoring::TSettings {
    public:
        inline const TString& GetSnapshotDirectory() const {
            return SnapshotDirectory;
        }

        inline void SetSnapshotDirectory(TString value) {
            SnapshotDirectory = value;
        }

    protected:
        void FillFromFileConfig(const NConfig::TConfig& config) override {
            TSettings::FillFromFileConfig(config);
            SetSnapshotDirectory(config["snapshot_dir"].As<TString>(""));
        }

    private:
        TString SnapshotDirectory;
    };
} // namespace NYasmServer
