LIBRARY()

OWNER(g:golovan)

PEERDIR(
    infra/yasm/common
    infra/yasm/interfaces
    infra/yasm/common/points/accumulators
    infra/yasm/zoom/components/compression
    infra/yasm/common/labels/host
    infra/yasm/zoom/components/record
    infra/yasm/zoom/components/serialization/deserializers
    infra/yasm/zoom/components/serialization/zoom_to_msgpack
    infra/yasm/zoom/components/serialization/zoom_to_protobuf
    infra/yasm/zoom/components/serialization/history
    infra/yasm/common/labels/signal
    infra/yasm/common/labels/tags
    infra/yasm/server/persistence
    infra/monitoring/common
    library/cpp/logger/global
    library/cpp/json
    library/cpp/http/server
    library/cpp/http/client
    library/cpp/threading/light_rw_lock
    library/cpp/containers/flat_hash
)

SRCS(
    storage/counted_sum_list.cpp
    storage/counters.cpp
    storage/float_list.cpp
    storage/fresh.cpp
    storage/histogram_list.cpp
    storage/host_index.cpp
    storage/record_list.cpp
    handlers.cpp
    load_signals.cpp
    msgpack_tools.cpp
    proto_handlers.cpp
    server_monitoring.cpp
    zoom_writers.cpp
)

END()

RECURSE(
    ut
    benchmark
    benchmark/metrics
)
