#pragma once

#include <infra/yasm/zoom/components/compression/series.h>
#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/zoom/components/serialization/deserializers/msgpack.h>

namespace NYasmServer {
    class TZoomValueWriter : public NZoom::NValue::IMultiUpdatable {
    public:
        enum AcceptanceType {
            DENIED = 1,
            ACCEPTED_NON_HGRAM = 2,
            ACCEPTED_SMALL = 3,
            ACCEPTED_NORMAL = 4,
            ACCEPTED_UGRAM = 5
        };

        TZoomValueWriter(IRecordList* series, TInstant timestamp)
            : Series(series)
            , Timestamp(timestamp) {
        }

        void MulNone() final {
            if (!WasAccepted()) {
                Accepted = AcceptanceType::ACCEPTED_NON_HGRAM;
            }
        }

        void MulFloat(const double value) final;
        void MulVec(const TVector<double>& values) final;
        void MulCountedSum(const double sum, const ui64 count) final;

        void MulHyperLogLog(const ::THyperLogLog&) final {
            Y_FAIL("This is impossible - hyperloglogs are not passed between server processes");
        }

        // histogram callbacks
        void OnStoreSmall(const TVector<double>& values, const size_t zeroes) final;
        void OnStoreSmall(const TArrayRef<const double>& values, size_t zeroes) final;
        void OnStoreNormal(const TVector<double>& values, const size_t zeroes, const i16 startPower) final;
        void OnStoreNormal(const TArrayRef<const double>& values, size_t zeroes, i16 startPower) final;
        void OnStoreUgram(const NZoom::NHgram::TUgramBuckets& buckets) final;

        bool WasAccepted() const {
            return Accepted != AcceptanceType::DENIED;
        }

        AcceptanceType GetAcceptanceType() const {
            return Accepted;
        }

    private:
        IRecordList* Series;
        TInstant Timestamp;
        AcceptanceType Accepted = AcceptanceType::DENIED;
    };
} // namespace NYasmServer
