#pragma once
#include <util/stream/output.h>
#include <util/ysaveload.h>

namespace NYasmServer {
    namespace NPersistence {
        namespace NImpl {
            struct TDataChunkHeader {
                ui32 Key;
                ui32 Signal;
                ui32 Host;
                ui32 Start;
                ui32 ValuesCount;
                ui8 Kind;

                void Save(IOutputStream* out) const {
                    ::Save<ui32>(out, Key);
                    ::Save<ui32>(out, Signal);
                    ::Save<ui32>(out, Host);
                    ::Save<ui32>(out, Start);
                    ::Save<ui32>(out, ValuesCount);
                    ::Save<ui8>(out, Kind);
                }

                void Load(IInputStream* stream) {
                    ::Load<ui32>(stream, Key);
                    ::Load<ui32>(stream, Signal);
                    ::Load<ui32>(stream, Host);
                    ::Load<ui32>(stream, Start);
                    ::Load<ui32>(stream, ValuesCount);
                    ::Load<ui8>(stream, Kind);
                }
            };

            struct TChunk {
                TDataChunkHeader Header;
                TString Data;

                void Save(IOutputStream* out) const {
                    ::Save(out, Header);
                    ::Save(out, Data);
                }

                void Load(IInputStream* stream) {
                    ::Load(stream, Header);
                    ::Load(stream, Data);
                }
            };
        } // namespace NImpl
    }     // namespace NPersistence
} // namespace NYasmServer
