#include "reader.h"

#include <library/cpp/testing/unittest/gtest.h>

#include <util/generic/xrange.h>

using namespace NYasmServer;
using namespace NPersistence;

Y_UNIT_TEST_SUITE(TestParsedSnapshotName) {
    Y_UNIT_TEST(TestSort) {
        TVector<TParsedSnapshotName> snapshotNames = {
            {TInstant::Seconds(17), 1, "snapshot_17_1"},
            {TInstant::Seconds(17), 2, "snapshot_17_2"},
            {TInstant::Seconds(18), 1, "snapshot_18_1"},
            {TInstant::Seconds(18), 2, "snapshot_18_2"},
        };
        Sort(snapshotNames);

        for (size_t i: xrange(snapshotNames.size())) {
            UNIT_ASSERT(snapshotNames[i] <= snapshotNames[i]);
            UNIT_ASSERT(!(snapshotNames[i] < snapshotNames[i]));
        }
        for (size_t i: xrange(snapshotNames.size() - 1)) {
            for (size_t j: xrange(i + 1, snapshotNames.size())) {
                UNIT_ASSERT(snapshotNames[i] < snapshotNames[j]);
                UNIT_ASSERT(snapshotNames[i] <= snapshotNames[j]);
                UNIT_ASSERT(!(snapshotNames[j] < snapshotNames[i]));
                UNIT_ASSERT(!(snapshotNames[j] <= snapshotNames[i]));
            }

        }
    }
}
