#pragma once

#include "common.h"
#include "impl.h"

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/labels/signal/signal_name.h>

#include <library/cpp/logger/global/global.h>

#include <util/datetime/base.h>
#include <util/folder/path.h>
#include <util/generic/vector.h>
#include <util/system/spinlock.h>

namespace NYasmServer {
    namespace NPersistence {
        class ISnapshotManager {
        public:
            virtual void WriteChunks(const TVector<TDataChunk>& chunks, const TString& baseFileName = "") = 0;
            virtual void Cleanup(TInstant deadline) = 0;
            virtual ~ISnapshotManager() = default;
        };

        class TDevNullManager : public ISnapshotManager {
        public:
            void WriteChunks(const TVector<TDataChunk>&, const TString& = "") override {
            }

            void Cleanup(TInstant) override {
            }

            static TDevNullManager& GetSingleton();
        }; // namespace NPersistence

        class TSnapshotManager : public ISnapshotManager {
        public:
            TSnapshotManager(const TFsPath& directory,
                             TLog& logger = TLoggerOperator<TNullLog>::Log(),
                             size_t maxBufferSize = 1000000,
                             size_t maxBufferCount = 50);

            void WriteChunks(const TVector<TDataChunk>& chunks, const TString& baseFileName = "") override;

            void Cleanup(TInstant deadline) override;

        private:
            void DumpChunks(const TVector<TDataChunk>& chunks, const TString& baseFileName, const TString& tempFileName);

        private:
            TFsPath Directory;
            TLog& Logger;
            size_t MaxBufferSize;
            size_t MaxBufferCount;
        };
    } // namespace NPersistence
} // namespace NYasmServer
