#pragma once

#include "common.h"

#include <library/cpp/digest/crc32c/crc32c.h>
#include <util/stream/buffered.h>

namespace NYasmServer {
    namespace NPersistence {
        class TCrc32Output : public IOutputStream {
        public:
            ui32 GetCrc() const {
                return Crc;
            }

        protected:
            void DoWrite(const void* buf, size_t len) override {
                Crc = Crc32cExtend(Crc, buf, len);
            }

        private:
            ui32 Crc = 0;
        };

        class TBufferedCrc32Output : public TBufferedOutput {
        public:
            TBufferedCrc32Output()
                : TBufferedOutput(&CrcOutput, CRC_BUFFER_LENGTH) {
                SetPropagateMode(true);
            }

            ui32 GetCrc() const {
                return CrcOutput.GetCrc();
            }

        private:
            TCrc32Output CrcOutput;
        };
    } // namespace NPersistence
} // namespace NYasmServer
