#pragma once

#include "base_types.h"

namespace NHistDb::NStockpile::NTest {
    inline TMetabaseShardKey MakeMetabaseShardKey(
            const NTags::TInstanceKey instanceKey
    ) {
        // TODO test for many shards
        TString signalNameString {"signal_xxxx"};
        NZoom::NSignal::TSignalName signalName {signalNameString};
        return TMetabaseShardKey::Make(instanceKey, signalName, 1);
    }

    inline TMetabaseShardKey MakeMetabaseShardKey(
            const NZoom::NHost::THostName& host,
            const NTags::TRequestKey& requestKey
    ) {
        TString signalNameString {"signal_xxxx"};
        NZoom::NSignal::TSignalName signalName {signalNameString};
        return TMetabaseShardKey::Make(host, requestKey, signalName, 1);
    }
}

