#include "base_types.h"

#include <solomon/protos/metabase/status_code.pb.h>
#include <solomon/protos/model/metric.pb.h>
#include <solomon/protos/stockpile/status_code.pb.h>
#include <solomon/protos/model/selector.pb.h>

#include <contrib/libs/grpc/include/grpcpp/grpcpp.h>

using yandex::solomon::metabase::EMetabaseStatusCode;
using yandex::solomon::model::MetricType;
using NHistDb::NStockpile::EStockpileDatabase;
using yandex::solomon::model::MatchType;
using yandex::solomon::stockpile::EStockpileStatusCode;

template <>
void Out<EMetabaseStatusCode>(IOutputStream& stream,
                              TTypeTraits<EMetabaseStatusCode>::TFuncParam statusCode) {
    stream << "EMetabaseStatusCode::";
    switch (statusCode) {
        case EMetabaseStatusCode::UNKNOWN: {
            stream << "UNKNOWN";
            return;
        }
        case EMetabaseStatusCode::OK: {
            stream << "OK";
            return;
        }
        case EMetabaseStatusCode::INTERNAL_ERROR: {
            stream << "INTERNAL_ERROR";
            return;
        }
        case EMetabaseStatusCode::DEADLINE_EXCEEDED: {
            stream << "DEADLINE_EXCEEDED";
            return;
        }
        case EMetabaseStatusCode::NODE_UNAVAILABLE: {
            stream << "NODE_UNAVAILABLE";
            return;
        }
        case EMetabaseStatusCode::INVALID_REQUEST: {
            stream << "INVALID_REQUEST";
            return;
        }
        case EMetabaseStatusCode::RESOURCE_EXHAUSTED: {
            stream << "RESOURCE_EXHAUSTED";
            return;
        }
        case EMetabaseStatusCode::NOT_FOUND: {
            stream << "NOT_FOUND";
            return;
        }
        case EMetabaseStatusCode::SHARD_NOT_FOUND: {
            stream << "SHARD_NOT_FOUND";
            return;
        }
        case EMetabaseStatusCode::DUPLICATE: {
            stream << "DUPLICATE";
            return;
        }
        case EMetabaseStatusCode::SHARD_NOT_READY: {
            stream << "SHARD_NOT_READY";
            return;
        }
        case EMetabaseStatusCode::SHARD_READ_ONLY: {
            stream << "SHARD_READ_ONLY";
            return;
        }
        case EMetabaseStatusCode::QUOTA_ERROR: {
            stream << "QUOTA_ERROR";
            return;
        }
        default: {
            stream << "__WRONG_ENUM__";
            return;
        }
    };
}

template <>
void Out<EStockpileStatusCode>(IOutputStream& stream,
                               TTypeTraits<EStockpileStatusCode>::TFuncParam statusCode) {
    stream << "EStockpileStatusCode::";
    switch (statusCode) {
        case EStockpileStatusCode::UNKNOWN: {
            stream << "UNKNOWN";
            return;
        }
        case EStockpileStatusCode::OK: {
            stream << "OK";
            return;
        }
        case EStockpileStatusCode::INTERNAL_ERROR: {
            stream << "INTERNAL_ERROR";
            return;
        }
        case EStockpileStatusCode::METRIC_NOT_FOUND: {
            stream << "METRIC_NOT_FOUND";
            return;
        }
        case EStockpileStatusCode::INVALID_TIME_SERIES_TYPE: {
            stream << "INVALID_TIME_SERIES_TYPE";
            return;
        }
        case EStockpileStatusCode::SHARD_ABSENT_ON_HOST: {
            stream << "SHARD_ABSENT_ON_HOST";
            return;
        }
        case EStockpileStatusCode::SHARD_NOT_READY: {
            stream << "SHARD_NOT_READY";
            return;
        }
        case EStockpileStatusCode::METRIC_ALREADY_EXISTS: {
            stream << "METRIC_ALREADY_EXISTS";
            return;
        }
        case EStockpileStatusCode::DEADLINE_EXCEEDED: {
            stream << "DEADLINE_EXCEEDED";
            return;
        }
        case EStockpileStatusCode::NODE_UNAVAILABLE: {
            stream << "NODE_UNAVAILABLE";
            return;
        }
        case EStockpileStatusCode::NOTE_ENOUGH_READY_SHARDS: {
            stream << "NOTE_ENOUGH_READY_SHARDS";
            return;
        }
        case EStockpileStatusCode::UNSUPPORTED_BINARY_FORMAT: {
            stream << "UNSUPPORTED_BINARY_FORMAT";
            return;
        }
        case EStockpileStatusCode::CORRUPTED_BINARY_DATA: {
            stream << "CORRUPTED_BINARY_DATA";
            return;
        }
        case EStockpileStatusCode::INVALID_REQUEST: {
            stream << "INVALID_REQUEST";
            return;
        }
        case EStockpileStatusCode::RESOURCE_EXHAUSTED: {
            stream << "RESOURCE_EXHAUSTED";
            return;
        }
        default: {
            stream << "__WRONG_ENUM__";
            return;
        }
    };
}

template <>
void Out<MatchType>(IOutputStream& stream,
                     TTypeTraits<MatchType>::TFuncParam matchType) {
    stream << "MatchType::";
    switch (matchType) {
        case MatchType::ABSENT: {
            stream << "ABSENT";
            return;
        }
        case MatchType::ANY: {
            stream << "ANY";
            return;
        }
        case MatchType::EXACT: {
            stream << "EXACT";
            return;
        }
        case MatchType::GLOB: {
            stream << "GLOB";
            return;
        }
        case MatchType::NOT_EXACT: {
            stream << "NOT_EXACT";
            return;
        }
        case MatchType::NOT_GLOB: {
            stream << "NOT_GLOB";
            return;
        }
        case MatchType::NOT_REGEX: {
            stream << "NOT_REGEX";
            return;
        }
        case MatchType::REGEX: {
            stream << "REGEX";
            return;
        }
        default: {
            stream << "__WRONG_ENUM__";
            return;
        }
    };
}

template <>
void Out<MetricType>(IOutputStream& stream,
                      TTypeTraits<MetricType>::TFuncParam sensorKind) {
    stream << "MetricType::";
    switch (sensorKind) {
        case MetricType::COUNTER: {
            stream << "COUNTER";
            return;
        }
        case MetricType::DGAUGE: {
            stream << "DGAUGE";
            return;
        }
        case MetricType::DSUMMARY: {
            stream << "DSUMMARY";
            return;
        }
        case MetricType::HIST: {
            stream << "HIST";
            return;
        }
        case MetricType::HIST_RATE: {
            stream << "HIST_RATE";
            return;
        }
        case MetricType::IGAUGE: {
            stream << "IGAUGE";
            return;
        }
        case MetricType::ISUMMARY: {
            stream << "ISUMMARY";
            return;
        }
        case MetricType::LOG_HISTOGRAM: {
            stream << "LOG_HISTOGRAM";
            return;
        }
        case MetricType::RATE: {
            stream << "RATE";
            return;
        }
        case MetricType::METRIC_TYPE_UNSPECIFIED: {
            stream << "METRIC_TYPE_UNSPECIFIED";
            return;
        }
        default: {
            stream << "__WRONG_ENUM__";
            return;
        }
    };
}

template <>
void Out<EStockpileDatabase>(IOutputStream& stream,
                             TTypeTraits<EStockpileDatabase>::TFuncParam database) {
    stream << "EStockpileDatabase::";
    switch (database) {
        case EStockpileDatabase::Metabase: {
            stream << "Metabase";
            return;
        }
        case EStockpileDatabase::Stockpile: {
            stream << "Stockpile";
            return;
        }
        case EStockpileDatabase::DataProxy: {
            stream << "DataProxy";
            return;
        }
    };
}

template <>
void Out<grpc::StatusCode>(IOutputStream& stream,
                           TTypeTraits<grpc::StatusCode>::TFuncParam statusCode) {
    using grpc::StatusCode;
    stream << "StatusCode::";
    switch (statusCode) {
        case StatusCode::OK: {
            stream << "OK";
            return;
        }
        case StatusCode::CANCELLED: {
            stream << "CANCELLED";
            return;
        }
        case StatusCode::UNKNOWN: {
            stream << "UNKNOWN";
            return;
        }
        case StatusCode::INVALID_ARGUMENT: {
            stream << "INVALID_ARGUMENT";
            return;
        }
        case StatusCode::DEADLINE_EXCEEDED: {
            stream << "DEADLINE_EXCEEDED";
            return;
        }
        case StatusCode::NOT_FOUND: {
            stream << "NOT_FOUND";
            return;
        }
        case StatusCode::ALREADY_EXISTS: {
            stream << "ALREADY_EXISTS";
            return;
        }
        case StatusCode::PERMISSION_DENIED: {
            stream << "PERMISSION_DENIED";
            return;
        }
        case StatusCode::UNAUTHENTICATED: {
            stream << "UNAUTHENTICATED";
            return;
        }
        case StatusCode::RESOURCE_EXHAUSTED: {
            stream << "RESOURCE_EXHAUSTED";
            return;
        }
        case StatusCode::FAILED_PRECONDITION: {
            stream << "FAILED_PRECONDITION";
            return;
        }
        case StatusCode::ABORTED: {
            stream << "ABORTED";
            return;
        }
        case StatusCode::OUT_OF_RANGE: {
            stream << "OUT_OF_RANGE";
            return;
        }
        case StatusCode::UNIMPLEMENTED: {
            stream << "UNIMPLEMENTED";
            return;
        }
        case StatusCode::INTERNAL: {
            stream << "INTERNAL";
            return;
        }
        case StatusCode::UNAVAILABLE: {
            stream << "UNAVAILABLE";
            return;
        }
        case StatusCode::DATA_LOSS: {
            stream << "DATA_LOSS";
            return;
        }
        default: {
            stream << "__WRONG_ENUM__";
            return;
        }
    }
}
