#include "listener.h"

using namespace NHistDb::NStockpile;

void TTopologyObserver::OnChangedMetabaseShard(const TMetabaseShardKey& shardKey) {
    TLightReadGuard rg(Lock);
    for (auto& listener : Listeners) {
        listener->OnChangedMetabaseShard(shardKey);
    }
}

void TTopologyObserver::OnChangedStockpileShard(const TStockpileShardId& shardId) {
    TLightReadGuard rg(Lock);
    for (auto& listener : Listeners) {
        listener->OnChangedStockpileShard(shardId);
    }
}

ITopologyListener* TTopologyObserver::RegisterImpl(THolder<ITopologyListener> listener) {
    TLightWriteGuard rg(Lock);
    Listeners.emplace_back(std::move(listener));
    return Listeners.back().Get();
}

void TTopologyObserver::Erase(ITopologyListener* listener) {
    TLightWriteGuard rg(Lock);
    Listeners.erase(std::remove_if(Listeners.begin(), Listeners.end(), [listener](const THolder<ITopologyListener>& element) {
        return element.Get() == listener;
    }));
}
