#pragma once

#include <infra/yasm/stockpile_client/common/base_types.h>
#include "stockpile_client.h"

namespace NHistDb::NStockpile {
    class ITopologyListener {
    public:
        virtual ~ITopologyListener() = default;

        virtual void OnChangedMetabaseShard(const TMetabaseShardKey& shardKey) = 0;
        virtual void OnChangedStockpileShard(const TStockpileShardId& shardId) = 0;
    };

    class TTopologyObserver final : public ITopologyListener {
    public:
        void OnChangedMetabaseShard(const TMetabaseShardKey& shardKey) override;
        void OnChangedStockpileShard(const TStockpileShardId& shardId) override;

        template <class T>
        T* Register(THolder<T> listener) {
            return dynamic_cast<T*>(RegisterImpl(std::move(listener)));
        }

        void Erase(ITopologyListener* listener);

    private:
        ITopologyListener* RegisterImpl(THolder<ITopologyListener> listener);

        TVector<THolder<ITopologyListener>> Listeners;
        TLightRWLock Lock;
    };
}
