#include "listener.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb::NStockpile;

class TMemorizingListener final : public ITopologyListener {
public:
    void OnChangedMetabaseShard(const TMetabaseShardKey& shardKey) override {
        MetabaseShards.emplace_back(shardKey);
    }

    void OnChangedStockpileShard(const TStockpileShardId& shardId) override {
        StockpileShards.emplace_back(shardId);
    }

    TVector<TMetabaseShardKey> MetabaseShards;
    TVector<TStockpileShardId> StockpileShards;
};

Y_UNIT_TEST_SUITE(TTopologyListenerTest) {

    Y_UNIT_TEST(Observer) {
        TMetabaseShardKey metabaseShard("a", "b", "c");
        TStockpileShardId stockpileShard(1);

        TTopologyObserver observer;
        TMemorizingListener* listener = observer.Register(MakeHolder<TMemorizingListener>());
        UNIT_ASSERT(listener != nullptr);
        observer.OnChangedMetabaseShard(metabaseShard);
        observer.OnChangedStockpileShard(stockpileShard);
        UNIT_ASSERT_VALUES_EQUAL(listener->MetabaseShards, TVector<TMetabaseShardKey>{metabaseShard});
        UNIT_ASSERT_VALUES_EQUAL(listener->StockpileShards, TVector<TStockpileShardId>{stockpileShard});
        observer.Erase(listener);

        observer.OnChangedMetabaseShard(metabaseShard);
        observer.OnChangedStockpileShard(stockpileShard);
    }

}
