#pragma once

#include "rpc.h"
#include "shard_cache.h"

#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/stockpile_client/common/base_types.h>

#include <solomon/protos/metabase/grpc_status.pb.h>
#include <solomon/protos/metabase/metabase_service.grpc.pb.h>

#include <library/cpp/logger/log.h>
#include <util/generic/vector.h>

namespace NHistDb::NStockpile {

    using TNumId = NProtoBuf::uint32;

    class TStockpileMetabaseClient {
    public:
        using TServerStatusCallState = TGrpcAsyncCallState<decltype(&TMetabaseService::Stub::PrepareAsyncServerStatus)>;
        using TResolveManyCallState = TGrpcAsyncCallState<decltype(&TMetabaseService::Stub::PrepareAsyncResolveMany)>;
        using TCreateManyCallState = TGrpcAsyncCallState<decltype(&TMetabaseService::Stub::PrepareAsyncCreateMany)>;
        using TFindCallState = TGrpcAsyncCallState<decltype(&TMetabaseService::Stub::PrepareAsyncFind)>;

        TStockpileMetabaseClient(TAtomicSharedPtr<TGrpcRemoteHost> host, TLog& log)
            : Host(std::move(host))
            , Log(log)
        {
            Y_UNUSED(Log);
        }

        TAtomicSharedPtr<TGrpcRemoteHost> GetHost() const;
        TServerStatusCallState ServerStatus();

        TResolveManyCallState ResolveManySensor(
            const TLabels& commonLabels, const TVector<TLabels>& sensorLabels);
        TCreateManyCallState CreateManySensor(
            const TLabels& commonLabels,
            const TVector<TLabels>& sensorLabels,
            const TVector<yandex::solomon::model::MetricType>& sensorTypes);

        TFindCallState FindSensor(const TLabelSelectors& selectors, size_t offset, long limit);

    private:
        void CopyLabels(const TLabels& source, ::google::protobuf::RepeatedPtrField<yandex::solomon::model::Label>* dest);
        void CopySensor(const TLabels& labels, yandex::solomon::model::MetricType type, yandex::solomon::metabase::Metric* metric);

        TAtomicSharedPtr<TGrpcRemoteHost> Host;
        TLog& Log;
    };

    class TMetabaseStatusState final: public TGrpcState {
    public:
        struct TShardStatus {
            TMetabaseShardKey Key;
            TNumId NumId;
            bool Ready = false;
            bool ReadyWrite = false;

            bool operator==(const TShardStatus& other) const noexcept {
                return Key == other.Key && Ready == other.Ready && ReadyWrite == other.ReadyWrite;
            }

            bool operator!=(const TShardStatus& other) const noexcept {
                return !operator==(other);
            }
        };

        TMetabaseStatusState(TGrpcCompletionQueue& queue, TAtomicSharedPtr<TGrpcRemoteHost> host, TLog& log);

        void Handle() override;

        TVector<TShardStatus> GetResult() const;
        TAtomicSharedPtr<TGrpcRemoteHost> GetHost() const;

        TStringBuf GetRequestName() const override {
            return NHistDb::NStockpile::NMetrics::STOCKPILE_METABASE_GRPC_SERVER_STATUS;
        }

    private:
        TStockpileMetabaseClient Client;
        TLog& Log;

        TStockpileMetabaseClient::TServerStatusCallState CallState;
        TVector<TShardStatus> Shards;
    };
}
