#pragma once

#include <infra/yasm/stockpile_client/common/base_types.h>

#include <library/cpp/http/client/client.h>
#include <library/cpp/json/writer/json.h>

#include <library/cpp/logger/log.h>

namespace NHistDb::NStockpile {

    TString DetectBaseUrl(NHistDb::NStockpile::EStockpileClusterType clusterType);

    static const TString DEFAULT_ABC_SERVICE {"golovan"};

    class TShardCreationError: public yexception {};

    class TMetabaseShardManager {
    public:
        TMetabaseShardManager(const TSettings& settings);
        void CreateProject(const TMetabaseShardKey& shardKey) const;
        void CreateCluster(const TMetabaseShardKey& shardKey) const;
        void CreateService(const TMetabaseShardKey& shardKey) const;
        void CreateShard(const TMetabaseShardKey& shardKey) const;

    private:
        NJson::TJsonValue CheckForAlreadyExistError(NHttpFetcher::TResultRef response) const;
        NJson::TJsonValue MakeRequest(
            const TString& projectPath,
            const TMaybe<TString>& requestJson = Nothing(),
            const TDuration& timeout = TDuration::Seconds(5),
            bool existIsOk = true
        ) const;

        const TSettings& Settings;
        TString BaseUrl;
    };
}
