#include "metrics.h"

using namespace NHistDb::NStockpile::NMetrics;

void TStockpileStatsInitializer::Init(TUnistat& creator) const {
    DrillAhhhHole(creator, STOCKPILE_SHARD_CACHE_SIZE);
    DrillAhhhHole(creator, STOCKPILE_METABASE_CACHE_SIZE);
    DrillAhhhHole(creator, STOCKPILE_MISSING_METABASE_SHARDS);
    DrillAhhhHole(creator, STOCKPILE_METABASE_SHARDS_IN_CREATION_QUEUE);
    DrillAmmxHole(creator, STOCKPILE_SENSOR_CACHE_SIZE);
    DrillAhhhHole(creator, STOCKPILE_SENSORS_IN_MISSING_SHARDS);

    DrillSummHole(creator, STOCKPILE_SENSORS_SKIPPED);

    DrillSummHole(creator, STOCKPILE_QUEUES_SENT_BY_SIZE);
    DrillSummHole(creator, STOCKPILE_QUEUES_SENT_BY_AGE);
    DrillSummHole(creator, STOCKPILE_QUEUES_BLOCKED);
    DrillSummHole(creator, STOCKPILE_QUEUES_UNBLOCKED);

    DrillSummHole(creator, STOCKPILE_METABASE_SHARD_CREATION_ERROR);
    DrillSummHole(creator, STOCKPILE_METABASE_SHARD_CREATION_OPERATIONS);

    DrillHistogramHole(creator, DIFFERENT_UGRAM_BOUNDS);
    DrillHistogramHole(creator, DROPPED_UGRAM_BUCKETS);
    DrillHistogramHole(creator, CROPPED_UGRAMS);

    DrillSummHole(creator, ERROR_POINTS);

    for (const auto* metricName : ALL_REQUESTS) {
        InitGrpcRequestMetrics(creator, *metricName);
    }
}

TString TStockpileStatsInitializer::MakeFailMetricName(const TStringBuf metric) {
    return metric + ERROR_SUFFIX;
}

TString TStockpileStatsInitializer::MakeRttMetricName(TStringBuf metric) {
    return metric + RTT_SUFFIX;
}

void TStockpileStatsInitializer::InitGrpcRequestMetrics(TUnistat& creator, const TString& requestName) const {
    DrillHistogramHole(creator, requestName);
    DrillHistogramHole(creator, MakeRttMetricName(requestName));
    DrillSummHole(creator, MakeFailMetricName(requestName));
}
