#pragma once

#include <infra/monitoring/common/metrics.h>

#include <util/generic/string.h>

namespace NHistDb::NStockpile::NMetrics {
    static const TString STOCKPILE_SHARD_CACHE_SIZE = "stockpile.shard_cache_size";
    static const TString STOCKPILE_METABASE_CACHE_SIZE = "stockpile.metabase_shard_cache_size";
    static const TString STOCKPILE_MISSING_METABASE_SHARDS = "stockpile.metabase_shards_missing";
    static const TString STOCKPILE_METABASE_SHARDS_IN_CREATION_QUEUE = "stockpile.metabase_shards_in_creation_queue";
    static const TString STOCKPILE_SENSOR_CACHE_SIZE = "stockpile.sensor_cache_size";
    static const TString STOCKPILE_SENSORS_IN_MISSING_SHARDS = "stockpile.sensors_in_missing_shards";

    static const TString STOCKPILE_SENSORS_SKIPPED = "stockpile.sensors_skipped";

    static const TString STOCKPILE_QUEUES_SENT_BY_SIZE = "stockpile.queues_sent_by_size";
    static const TString STOCKPILE_QUEUES_SENT_BY_AGE = "stockpile.queues_sent_by_age";
    static const TString STOCKPILE_QUEUES_BLOCKED = "stockpile.queues_blocked";
    static const TString STOCKPILE_QUEUES_UNBLOCKED = "stockpile.queues_unblocked";

    static const TString STOCKPILE_METABASE_SHARD_CREATION_ERROR = "stockpile_metabase.shard_creation_error";
    static const TString STOCKPILE_METABASE_SHARD_CREATION_OPERATIONS = "stockpile_metabase.shard_creation_operations";

    static const TString STOCKPILE_DISCOVERY = "discovery_handle";

    static const TString STOCKPILE_METABASE_GRPC_SERVER_STATUS = "stockpile_metabase.grpc_server_status";
    static const TString STOCKPILE_METABASE_GRPC_SENSOR_CREATE = "stockpile_metabase.grpc_sensor_create";
    static const TString STOCKPILE_METABASE_GRPC_SENSOR_RESOLVE = "stockpile_metabase.grpc_sensor_resolve";
    static const TString STOCKPILE_METABASE_GRPC_SENSOR_FIND = "stockpile_metabase.grpc_sensor_find";

    static const TString STOCKPILE_GRPC_SERVER_STATUS = "stockpile.grpc_server_status";
    static const TString STOCKPILE_GRPC_WRITE_MANY = "stockpile.grpc_write_many";
    static const TString STOCKPILE_GRPC_READ_MANY = "stockpile.grpc_read_many";
    static const TString STOCKPILE_GRPC_DELETE_DATA = "stockpile.grpc_delete_data";

    static const TString DIFFERENT_UGRAM_BOUNDS = "different_ugram_bounds";
    static const TString DROPPED_UGRAM_BUCKETS = "dropped_ugram_buckets";
    static const TString CROPPED_UGRAMS = "cropped_ugrams";

    static const TString ERROR_POINTS = "error_points";

    static const TVector<const TString*> ALL_REQUESTS{
        &STOCKPILE_DISCOVERY,
        &STOCKPILE_METABASE_GRPC_SERVER_STATUS,
        &STOCKPILE_METABASE_GRPC_SENSOR_CREATE,
        &STOCKPILE_METABASE_GRPC_SENSOR_RESOLVE,
        &STOCKPILE_METABASE_GRPC_SENSOR_FIND,
        &STOCKPILE_GRPC_SERVER_STATUS,
        &STOCKPILE_GRPC_WRITE_MANY,
        &STOCKPILE_GRPC_READ_MANY,
    };

    static const TString ERROR_SUFFIX = "_error";
    static const TString RTT_SUFFIX = "_rtt";

    class TStockpileStatsInitializer final : public NMonitoring::TStatsInitializer {
    public:
        void Init(TUnistat& creator) const;
        void InitGrpcRequestMetrics(TUnistat& creator, const TString& requestName) const;

        static TString MakeFailMetricName(TStringBuf metric);
        static TString MakeRttMetricName(TStringBuf metric);
    };
}
