#pragma once

#include <solomon/libs/cpp/timeseries/timeseries.h>
#include <solomon/libs/cpp/ts_model/point_type.h>
#include <solomon/protos/stockpile/stockpile_requests.pb.h>
#include <infra/yasm/stockpile_client/points.h>

namespace NHistDb::NStockpile {

inline static NSolomon::TAggrPointWithType MakePoint(const yandex::solomon::stockpile::TPoint& point, yandex::solomon::model::MetricType type) {
    auto time = TInstant::MilliSeconds(point.GetTimestampsMillis());
    switch (type) {
        case yandex::solomon::model::MetricType::DSUMMARY: {
            const auto& proto = point.GetSummaryDouble();
            auto summary = MakeIntrusive<NMonitoring::TSummaryDoubleSnapshot>(proto.sum(), proto.min(), proto.max(), proto.last(), proto.count());
            return {time, summary.Get()};
        }
        case yandex::solomon::model::MetricType::LOG_HISTOGRAM: {
            const auto& proto = point.GetLogHistogram();
            TVector<double> buckets;
            buckets.reserve(proto.bucketsSize());
            for (double bucket : proto.buckets()) {
                buckets.push_back(bucket);
            }

            auto hist = MakeIntrusive<NMonitoring::TLogHistogramSnapshot>(proto.base(), proto.zeroes(), proto.start_power(), std::move(buckets));
            return {time, hist.Get()};
        }
        case yandex::solomon::model::MetricType::HIST: {
            const auto& proto = point.GetHistogram();;
            auto hist = NMonitoring::TExplicitHistogramSnapshot::New(proto.bucketsSize());
            for (int index = 0; index < static_cast<int>(proto.bucketsSize()); ++index) {
                (*hist)[index].first = proto.bounds(index);
                (*hist)[index].second = proto.buckets(index);
            }

            return {time, hist.Get()};
        }
        default: {
            ythrow TTypeNotSupportedException() << type << " is not supported";
        }
    }
}

inline NSolomon::NTsModel::EPointType ToPointType(yandex::solomon::model::MetricType type) {
    switch (type) {
        case yandex::solomon::model::MetricType::DSUMMARY: {
            return NSolomon::NTsModel::EPointType::DSummary;
        }
        case yandex::solomon::model::MetricType::LOG_HISTOGRAM: {
            return NSolomon::NTsModel::EPointType::LogHist;
        }
        case yandex::solomon::model::MetricType::HIST: {
            return NSolomon::NTsModel::EPointType::Hist;
        }
        default: {
            ythrow TTypeNotSupportedException() << type << " is not supported";
        }
    }
}

} // NHistDb::NStockpile
