#include "proto_to_slog_converter.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb::NStockpile;
using namespace yandex::solomon::stockpile;
using namespace yandex::solomon::model;

Y_UNIT_TEST_SUITE(TProtoConverterTest) {

    Y_UNIT_TEST(DSummary) {
        TInstant now = TInstant::MilliSeconds(123456L);
        TPoint proto;
        proto.set_timestampsmillis(now.MilliSeconds());
        proto.MutableSummaryDouble()->set_sum(1);
        proto.MutableSummaryDouble()->set_min(2);
        proto.MutableSummaryDouble()->set_max(3);
        proto.MutableSummaryDouble()->set_count(4);
        proto.MutableSummaryDouble()->set_last(5);

        auto actual = MakePoint(proto, MetricType::DSUMMARY);
        UNIT_ASSERT_EQUAL(now, actual.GetTime());
        UNIT_ASSERT_EQUAL(1, actual.GetValue().AsSummaryDouble()->GetSum());
        UNIT_ASSERT_EQUAL(2, actual.GetValue().AsSummaryDouble()->GetMin());
        UNIT_ASSERT_EQUAL(3, actual.GetValue().AsSummaryDouble()->GetMax());
        UNIT_ASSERT_EQUAL(4, actual.GetValue().AsSummaryDouble()->GetCount());
        UNIT_ASSERT_EQUAL(5, actual.GetValue().AsSummaryDouble()->GetLast());
    }

    Y_UNIT_TEST(LogHist) {
        TInstant now = TInstant::MilliSeconds(123456L);
        TPoint proto;
        proto.set_timestampsmillis(now.MilliSeconds());
        proto.MutableLogHistogram()->set_base(1.5);
        proto.MutableLogHistogram()->set_zeroes(123);
        proto.MutableLogHistogram()->set_start_power(10);
        proto.MutableLogHistogram()->add_buckets(1);
        proto.MutableLogHistogram()->add_buckets(0);
        proto.MutableLogHistogram()->add_buckets(5);
        proto.MutableLogHistogram()->add_buckets(6);

        auto actual = MakePoint(proto, MetricType::LOG_HISTOGRAM);
        UNIT_ASSERT_EQUAL(now, actual.GetTime());
        UNIT_ASSERT_EQUAL(1.5, actual.GetValue().AsLogHistogram()->Base());
        UNIT_ASSERT_EQUAL(123, actual.GetValue().AsLogHistogram()->ZerosCount());
        UNIT_ASSERT_EQUAL(10, actual.GetValue().AsLogHistogram()->StartPower());
        UNIT_ASSERT_EQUAL(1, actual.GetValue().AsLogHistogram()->Bucket(0));
        UNIT_ASSERT_EQUAL(0, actual.GetValue().AsLogHistogram()->Bucket(1));
        UNIT_ASSERT_EQUAL(5, actual.GetValue().AsLogHistogram()->Bucket(2));
        UNIT_ASSERT_EQUAL(6, actual.GetValue().AsLogHistogram()->Bucket(3));
    }

    Y_UNIT_TEST(Hist) {
        TInstant now = TInstant::MilliSeconds(123456L);
        TPoint proto;
        proto.set_timestampsmillis(now.MilliSeconds());
        proto.MutableHistogram()->add_bounds(1);
        proto.MutableHistogram()->add_bounds(2);
        proto.MutableHistogram()->add_bounds(4);
        proto.MutableHistogram()->add_bounds(8);
        proto.MutableHistogram()->add_buckets(3);
        proto.MutableHistogram()->add_buckets(2);
        proto.MutableHistogram()->add_buckets(1);
        proto.MutableHistogram()->add_buckets(0);

        auto actual = MakePoint(proto, MetricType::HIST);
        UNIT_ASSERT_EQUAL(now, actual.GetTime());
        UNIT_ASSERT_EQUAL(1, actual.GetValue().AsHistogram()->UpperBound(0));
        UNIT_ASSERT_EQUAL(2, actual.GetValue().AsHistogram()->UpperBound(1));
        UNIT_ASSERT_EQUAL(4, actual.GetValue().AsHistogram()->UpperBound(2));
        UNIT_ASSERT_EQUAL(8, actual.GetValue().AsHistogram()->UpperBound(3));
        UNIT_ASSERT_EQUAL(3, actual.GetValue().AsHistogram()->Value(0));
        UNIT_ASSERT_EQUAL(2, actual.GetValue().AsHistogram()->Value(1));
        UNIT_ASSERT_EQUAL(1, actual.GetValue().AsHistogram()->Value(2));
        UNIT_ASSERT_EQUAL(0, actual.GetValue().AsHistogram()->Value(3));
    }
}
