#include "record_serialize_state.h"
#include "points.h"

using namespace NHistDb::NStockpile;
using namespace NZoom::NHgram;
using namespace NZoom::NAccumulators;

TRecordSerializeState::TRecordSerializeState(TSensorId sensorId, TNumId ownerShardNumId, EAccumulatorType aggregationType)
    : SensorId(sensorId)
    , OwnerShardNumId(ownerShardNumId)
    , AggregationType(aggregationType)
    , DifferentUgramBoundsCounter{}
    , CroppedUgramCounter{}
    , ErrorPointsCounter{}
{
}

const TUgramBuckets& TRecordSerializeState::FixUgramBuckets(const TUgramBuckets& buckets) {
    if (UgramFreezer.Defined()) {
        auto& resultBuckets = UgramFreezer->Freeze(buckets);
        if (HaveDifferentBounds(resultBuckets, buckets)) {
            DifferentUgramBoundsCounter++;
        }
        return resultBuckets;
    } else {
        return buckets;
    }
}

