#pragma once

#include <infra/yasm/stockpile_client/common/base_types.h>
#include <infra/yasm/stockpile_client/metabase_client.h>

#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/common/points/hgram/ugram_freezer.h>
#include <infra/yasm/zoom/components/record/record.h>

namespace NHistDb::NStockpile {
    static constexpr size_t STOCKPILE_HISTOGRAM_BUCKETS_LIMIT = 51;

    class TRecordUgramMergerVisitor final : public NZoom::NRecord::IRecordVisitor {
    public:
        void OnValue(NZoom::NValue::TValueRef value) override {
            value.Update(Merger);
        }

        TMaybe<NZoom::NHgram::TUgramBucketsFreezer> GetFreezer(const size_t limit = STOCKPILE_HISTOGRAM_BUCKETS_LIMIT) {
            // NOTE(rocco66): reserve last bucket for "inf", see https://st.yandex-team.ru/GOLOVAN-6544
            return Merger.GetFreezer(limit - 1);
        };

    private:
        NZoom::NHgram::TUgramMerger Merger;
    };

    class TRecordSerializeState {
    public:
        TRecordSerializeState(
            TSensorId sensorId,
            TNumId ownerShardNumId,
            NZoom::NAccumulators::EAccumulatorType aggregationType
        );

        void SetUgramFreezer(TMaybe<NZoom::NHgram::TUgramBucketsFreezer> ugramFreezer) {
            UgramFreezer = std::move(ugramFreezer);
        }

        const NZoom::NHgram::TUgramBuckets& FixUgramBuckets(const NZoom::NHgram::TUgramBuckets &buckets);

        yandex::solomon::model::MetricType GetType() const {
            return SensorId.Type;
        }

        const TSensorId& GetSensorId() const {
            return SensorId;
        }

        TNumId GetOwnerShardNumId() const {
            return OwnerShardNumId;
        }

        NZoom::NAccumulators::EAccumulatorType GetAggregationType() const {
            return AggregationType;
        }

        ui64 GetDifferentUgramBoundsCounter() const {
            return DifferentUgramBoundsCounter;
        }

        ui64 GetCroppedUgramCounter() const {
            return CroppedUgramCounter;
        }

        void IncCroppedUgramCounter() {
            CroppedUgramCounter++;
        }

        ui64 GetErrorPointsCounter() {
            return ErrorPointsCounter;
        }

        void IncErrorPointsCounter() {
            ErrorPointsCounter++;
        }

    private:
        TSensorId SensorId;
        TNumId OwnerShardNumId;
        NZoom::NAccumulators::EAccumulatorType AggregationType;
        ui64 DifferentUgramBoundsCounter;
        ui64 CroppedUgramCounter;
        ui64 ErrorPointsCounter;
        TMaybe<NZoom::NHgram::TUgramBucketsFreezer> UgramFreezer;
    };

}
