#include "rpc.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb::NStockpile;

Y_UNIT_TEST_SUITE(TGrpcSimpleTests) {

    Y_UNIT_TEST(RetryModeEnumValuesAreCorrect) {
        TGrpcRetryMode modeDefault;
        TGrpcRetryMode modeDeadline = EGrpcRetryModeFlags::ON_DEADLINE;
        TGrpcRetryMode modeInternalError = EGrpcRetryModeFlags::ON_INTERNAL_ERROR;
        TGrpcRetryMode modeFull = EGrpcRetryModeFlags::ON_DEADLINE | EGrpcRetryModeFlags::ON_INTERNAL_ERROR;

        UNIT_ASSERT(!modeDefault.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE));
        UNIT_ASSERT(!modeDefault.HasFlags(EGrpcRetryModeFlags::ON_INTERNAL_ERROR));
        UNIT_ASSERT(!modeDefault.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE | EGrpcRetryModeFlags::ON_INTERNAL_ERROR));

        UNIT_ASSERT(modeDeadline.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE));
        UNIT_ASSERT(!modeDeadline.HasFlags(EGrpcRetryModeFlags::ON_INTERNAL_ERROR));
        UNIT_ASSERT(!modeDeadline.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE | EGrpcRetryModeFlags::ON_INTERNAL_ERROR));

        UNIT_ASSERT(!modeInternalError.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE));
        UNIT_ASSERT(modeInternalError.HasFlags(EGrpcRetryModeFlags::ON_INTERNAL_ERROR));
        UNIT_ASSERT(!modeInternalError.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE | EGrpcRetryModeFlags::ON_INTERNAL_ERROR));

        UNIT_ASSERT(modeFull.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE));
        UNIT_ASSERT(modeFull.HasFlags(EGrpcRetryModeFlags::ON_INTERNAL_ERROR));
        UNIT_ASSERT(modeFull.HasFlags(EGrpcRetryModeFlags::ON_DEADLINE | EGrpcRetryModeFlags::ON_INTERNAL_ERROR));
    }

}
