#include "settings.h"

using namespace NHistDb::NStockpile;

void TStockpileSetingsFactory::FillParser(NLastGetopt::TOpts& options) {
    options.AddLongOption("stockpile-cluster-type", "which stockpile cluster will be used").Optional().RequiredArgument();
    options.AddLongOption("stockpile-cluster-name", "which data center will be used").Optional().RequiredArgument();
    options.AddLongOption("stockpile-metabase-config", "config for stockpile metabase").Optional().RequiredArgument();

}
void TStockpileSetingsFactory::ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed) {
    if (parsed.Has("stockpile-metabase-config")) {
        SetStockpileMetabaseConfigPath(parsed.Get("stockpile-metabase-config"));
    }

    SetStockpileClusterName(parsed.GetOrElse("stockpile-cluster-name", "man"));
    SetStockpileClusterTypeFromString(parsed.GetOrElse("stockpile-cluster-type", "prestable"));
    SetAuthToken(GetEnv("OAUTH_TOKEN", ""));
}

void TStockpileSetingsFactory::FillFromFileConfig(const NConfig::TConfig& config) {
    SetStockpileClusterTypeFromString(config["stockpile_cluster_type"].As<TString>("prestable"));
    SetStockpileClusterName(config["stockpile_cluster_name"].As<TString>("man"));
    SetAuthToken(GetEnv("OAUTH_TOKEN", ""));
}

TClusterInfo TStockpileSetingsFactory::GetClusterInfo() const {
    if (!StockpileClusterType.Defined()) {
        ythrow yexception() << "Stockpile Cluster Type doesn't set";
    }
    if (StockpileClusterName.empty()) {
        ythrow yexception() << "Stockpile Cluster Name doesn't set";
    }
    return {StockpileClusterType.GetRef(), StockpileClusterName};
}

TSettings TStockpileSetingsFactory::CreateStockpileSettings(bool createNewShards) const {
    TFileInput metabaseShardConfig {StockpileMetabaseConfigPath};
    return TSettings{
        GetClusterInfo(),
        AuthToken,
        createNewShards,
        {metabaseShardConfig.ReadAll()}
    };
}
