#include "shard_cache.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb::NStockpile;

Y_UNIT_TEST_SUITE(TShardCacheTest) {

    Y_UNIT_TEST(Cleanup) {
        TVector<TStockpileShardCache::TShardStatus> shards;
        shards.emplace_back(TStockpileShardCache::TShardStatus{
            .Key = 123,
            .ReadyWrite = true,
            .ReadyRead = true
        });

        TStockpileShardCache cache;
        cache.UpdateShardsForHost(std::make_pair("first", 1), shards);
        cache.Cleanup();
        UNIT_ASSERT_VALUES_EQUAL(cache.GetShardsForHost(std::make_pair("first", 1)), shards);

        cache.UpdateShardsForHost(std::make_pair("second", 2), shards);
        cache.Cleanup();
        UNIT_ASSERT_VALUES_EQUAL(cache.GetShardsForHost(std::make_pair("first", 1)), TVector<TStockpileShardCache::TShardStatus>{});
        UNIT_ASSERT_VALUES_EQUAL(cache.GetShardsForHost(std::make_pair("second", 2)), shards);
    }

    Y_UNIT_TEST(FailThreshold) {
        TVector<TStockpileShardCache::TShardStatus> shards;
        shards.emplace_back(TStockpileShardCache::TShardStatus{
            .Key = 123,
            .ReadyWrite = true,
            .ReadyRead = true
        });

        auto host(std::make_pair("first", 1));
        TStockpileShardCache cache;
        cache.UpdateShardsForHost(host, shards);
        cache.Cleanup();
        cache.MarkHostAsFailed(host);
        cache.Cleanup();
        cache.UpdateShardsForHost(host, shards);
        cache.Cleanup();
        UNIT_ASSERT_VALUES_EQUAL(cache.GetShardsForHost(host), shards);

        for (const auto idx : xrange(TStockpileShardCache::FAIL_THRESHOLD)) {
            cache.MarkHostAsFailed(host);
            cache.Cleanup();
            Y_UNUSED(idx);
        }
        UNIT_ASSERT_VALUES_EQUAL(cache.GetShardsForHost(host), TVector<TStockpileShardCache::TShardStatus>{});
    }

}
