#pragma once

#include "metabase_shard_provider.h"
#include "stockpile_shard.h"
#include "stockpile_shard_provider.h"
#include "cluster.h"

#include <infra/yasm/common/config/fast_config.h>

#include <util/system/thread.h>
#include <util/system/event.h>
#include <util/system/mutex.h>

namespace NHistDb {
    namespace NStockpile {
        class TStockpileState {
        public:
            TStockpileState(TLog& log, const TSettings& settings, const TFastConfig& fastConfig)
                : Settings(settings)
                , FastConfig(fastConfig)
                , MetabaseClusterProvider(EStockpileDatabase::Metabase, Settings.ClusterInfo, log)
                , MetabaseShardProvider(MetabaseClusterProvider, TopologyObserver, Settings, log)
                , StockpileClusterProvider(EStockpileDatabase::Stockpile, Settings.ClusterInfo, log)
                , StockpileShardProvider(StockpileClusterProvider, TopologyObserver, log)
                , Log(log)
                , Done(0)
            {
            }

            ~TStockpileState();

            TMetabaseShardState ResolveOneMetabaseShardForRead(TMetabaseShardKey key);
            TMetabaseShardState ResolveOneMetabaseShardForWrite(TMetabaseShardKey key);
            TMaybe<TMetabaseShardState> FindOneMetabaseShardForWrite(TMetabaseShardKey key);

            TAtomicSharedPtr<TStockpileShard> ResolveOneStockpileShardForRead(TStockpileShardId shardId) const;
            TAtomicSharedPtr<TStockpileShard> ResolveOneStockpileShardForWrite(TStockpileShardId shardId) const;

            TTopologyObserver& GetObserver() {
                return TopologyObserver;
            }

            const TSettings& GetSettings() const {
                return Settings;
            }
            EStockpileClusterType GetClusterType() const;
            TShardIndex GetShardsCount(TStringBuf itype) const;

            THashSet<TString> GetItypes() const {
                return MetabaseShardProvider.GetItypes();
            }

            TVector<TMetabaseShardKey> GetMetabaseShardKeys(bool skipUnavailable) const {
                return MetabaseShardProvider.GetShardKeys(skipUnavailable);
            }

            bool WritingIsDisabled() const {
                return FastConfig.Has(NYasm::NCommon::EFastConfigFlag::DISABLE_STOCKPILE_DUMP);
            }

            bool ReadingIsDisabled() const {
                return FastConfig.Has(NYasm::NCommon::EFastConfigFlag::DISABLE_STOCKPILE_READ);
            }

            void UpdateShards();
            void Start();
            void Stop();

        private:
            static void* DoRun(void* self) noexcept;
            void OnTick();

            const TSettings Settings;
            const TFastConfig& FastConfig;

            TTopologyObserver TopologyObserver;
            TClusterProvider MetabaseClusterProvider;
            TStockpileMetabaseAsyncShardProvider MetabaseShardProvider;
            TClusterProvider StockpileClusterProvider;
            TStockpileShardProvider StockpileShardProvider;

            TLog& Log;

            TAutoEvent Event;
            TAtomic Done;
            TMutex ThreadMutex;
            THolder<TThread> Thread;
        };

        class TDataProxyMultiClusterState {
        public:
            TDataProxyMultiClusterState(EStockpileClusterType clusterType, TLog& log);
            virtual ~TDataProxyMultiClusterState();

            void Start();
            void Stop();
            TVector<TVector<TAtomicSharedPtr<TGrpcRemoteHost>>> GetAllHosts() const;

        private:
            static void* DoRun(void* self) noexcept;
            void DoRun() noexcept;
            void UpdateInfo();

            TClusterProvider ClusterProvider;
            THolder<TThread> Thread;
            TAtomic Done;
        };
    }
}
