#pragma once

#include <infra/yasm/stockpile_client/state.h>
#include <infra/yasm/common/tests.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/logger/stream.h>

#include <util/system/env.h>
#include <util/generic/yexception.h>

namespace NHistDb::NStockpile::NTest {
    static const TString SOLOMON_TESTS_CLIENT_ID = "yasmtests";

    inline TSettings CreateTestSettings() {
        TClusterInfo info{EStockpileClusterType::Prestable, "man"};
        return TSettings{info, GetEnv("OAUTH_TOKEN"), true, {"[]"}};
    }

    inline NYasm::NCommon::TFastConfigSettings MakeTestingFastConfigSettings() {
        return {
            "oauth_token",
            "locke",
            {"//home/yasm/fast_config.json"},
            "fast_config.json",
            NTags::TInstanceKey::FromNamed("yasmdumper")
        };
    }

    struct TClient {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        ~TClient() {
            StockpileState.Stop();
            StockpileStateForClear.Stop();
        }

        static TClient& Get() {
            return *Singleton<TClient>();
        }

        TLog Log;
        TSettings Settings;
        TFastConfig FastConfig;
        NStockpile::TStockpileState StockpileState;
        NStockpile::TStockpileState StockpileStateForClear;

    private:
        TClient()
            : Log(NYasm::NCommon::NTest::CreateLog())
            , Settings(CreateTestSettings())
            , FastConfig {Log, MakeTestingFastConfigSettings()}
            , StockpileState(Log, Settings, FastConfig)
            , StockpileStateForClear(Log, Settings, FastConfig)
        {
            TGrpcSettings::Init(SOLOMON_TESTS_CLIENT_ID, Log);
            StockpileState.UpdateShards();
            StockpileState.Start();
            StockpileStateForClear.UpdateShards();
        }

    };
}
