#pragma once

#include "shard_cache.h"
#include "stockpile_shard.h"
#include "cluster.h"
#include "listener.h"

#include <library/cpp/logger/log.h>
#include <library/cpp/threading/light_rw_lock/lightrwlock.h>
#include <util/generic/hash.h>

namespace NHistDb {
    namespace NStockpile {
        static constexpr TDuration STOCKPILE_UPDATE_INTERVAL = TDuration::Seconds(40);
        static constexpr TDuration STOCKPILE_UPDATE_JITTER = TDuration::Seconds(20);

        class TStockpileShardProvider {
        public:
            TStockpileShardProvider(
                TClusterProvider& clusterProvider,
                ITopologyListener& listener,
                TLog& log
            );

            void TryToUpdateShards();

            TAtomicSharedPtr<TStockpileShard> ResolveOneShardForRead(TStockpileShardId shardId) const;
            TAtomicSharedPtr<TStockpileShard> ResolveOneShardForWrite(TStockpileShardId shardId) const;

        private:
            struct TShardState {
                TAtomicSharedPtr<TStockpileShard> Shard;
                TStockpileShardCache::TShardStatus Status;
            };

            using TStockpileShards = THashMap<TStockpileShardId, TShardState>;

            const TShardState& ResolveOneShard(TStockpileShardId shardId) const;

            void UpdateShards();

            TClusterProvider& ClusterProvider;
            ITopologyListener& Listener;
            TLog& Log;

            TStockpileShardCache ShardCache;
            TStockpileShards CurrentShards;

            TInstant LastUpdate;
            TLightRWLock ShardsLock;
        };
    }
}
