LIBRARY()

OWNER(g:golovan)

PEERDIR(
    infra/yasm/stockpile_client/common
    infra/yasm/common/config
    infra/yasm/common/labels/tags
    infra/yasm/common/labels/signal
    infra/yasm/common/labels/host
    infra/yasm/common/points/value
    infra/yasm/common
    infra/monitoring/common
    solomon/protos/common
    solomon/protos/metabase
    solomon/protos/model
    solomon/protos/stockpile
    solomon/services/dataproxy/api
    solomon/libs/cpp/grpc/interceptor
    solomon/libs/cpp/slog
    solomon/libs/cpp/slog/resolved_meta
    library/cpp/consistent_hashing
    library/cpp/json
    library/cpp/json/writer
    library/cpp/http/client
    library/cpp/logger
    library/cpp/yaml/as
    library/cpp/monlib/metrics
    contrib/libs/grpc
)

SRCS(
    cluster.cpp
    listener.cpp
    dataproxy_client.cpp
    metabase_client.cpp
    metabase_shard.cpp
    metabase_shard_manager.cpp
    metabase_shard_provider.cpp
    metrics.cpp
    points.cpp
    record_serialize_state.cpp
    rpc.cpp
    settings.cpp
    shard_cache.cpp
    state.cpp
    stockpile_client.cpp
    stockpile_shard.cpp
    stockpile_shard_provider.cpp
)

END()

RECURSE_FOR_TESTS(
    ut
    tests
    common/ut
)
