#pragma once

#include "metrics.h"

#include <infra/monitoring/common/proto_replier.h>
#include <infra/yasm/interfaces/internal/history_api.pb.h>
#include <infra/yasm/zoom/components/subscription/store.h>

namespace NSubscriptions {
    class TReadHistoryHandler final : public NMonitoring::TAbstractProtoReplier<
            NYasm::NInterfaces::NInternal::THistoryReadAggregatedRequest,
            NYasm::NInterfaces::NInternal::THistoryReadAggregatedResponse> {
    public:
        TReadHistoryHandler(NZoom::NSubscription::TPurifyingStore& store, TLog& logger)
            : Store(store)
            , Logger(logger)
        {
        }

        const TString& GetTimingMetricName() const override {
            return NMetrics::HANDLERS_READ_HISTORY_TIME;
        }

        const TString& GetHandleName() const override {
            return NMetrics::HANDLERS_READ_HISTORY_TIME;
        }

        TLog& GetLogger() override {
            return Logger;
        }

        void Handle(TProtoContext& context) override;

    private:
        NZoom::NSubscription::TPurifyingStore& Store;
        TLog& Logger;
    };
}
