#pragma once

#include <infra/monitoring/common/settings.h>

namespace {
    TString FAST_CONFIG_OPT("fast-conf");
}

namespace NSubscriptions {
    class TServerSettings final : public NMonitoring::TSettings {
    public:
        inline void SetFastConfigFilePath(const TString& value) {
            FastConfigFilePath = value;
        }

        inline const TFsPath& GetFastConfigFilePath() const {
            return FastConfigFilePath;
        }

        void ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed) {
            if (parsed.Has(FAST_CONFIG_OPT)) {
                SetFastConfigFilePath(parsed.Get(FAST_CONFIG_OPT));
            }
        }

        static void FillParser(NLastGetopt::TOpts& options) {
            options.AddLongOption(FAST_CONFIG_OPT, "path to fast config").Optional().RequiredArgument();
        }
    protected:
        void FillFromFileConfig(const NConfig::TConfig& config) override {
            TSettings::FillFromFileConfig(config);
        }
    private:
        TFsPath FastConfigFilePath;
    };
}
