#include <infra/monitoring/common/application.h>
#include <infra/yasm/subscriptions/lib/handlers.h>
#include <infra/yasm/subscriptions/lib/settings.h>
#include <infra/yasm/subscriptions/lib/metrics.h>

using namespace NSubscriptions;
using namespace NMonitoring;

class TSubscriptionStoreStatsInitializer final : public TStatsInitializer {
public:
    void Init(TUnistat& creator) const override {
        TStatsInitializer::Init(creator);

        DrillHistogramHole(creator, NMetrics::HANDLERS_PING_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_ADD_MANY_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_LIST_MANY_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_LIST_ALL_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_FLUSH_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_PUSH_VALUES_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_SET_VALUES_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_GET_VALUES_TIME);
        DrillHistogramHole(creator, NMetrics::HANDLERS_READ_HISTORY_TIME);
    }
};

class TSubscriptionStore final : public TBaseApplication<TServerSettings> {
public:
    TSubscriptionStore(TLog& logger, const TServerSettings& settings)
        : TBaseApplication(logger, settings)
        , FastConfig(logger, NYasm::NCommon::MakeYasmFastConfigSettings(settings.GetFastConfigFilePath()))
        , HttpHandlers(
              logger,
              &FastConfig
          )
    {
    }

    void Run() override {
        HttpHandlers.Register(HttpServer);
        FastConfig.Start();
        HttpServer.StartServing();
        Event.Wait();
    }

    void Stop(int signal) override {
        TBaseApplication::Stop(signal);
        FastConfig.Stop();
    }

    static void FillParser(NLastGetopt::TOpts& options) {
        TServerSettings::FillParser(options);
    }

    static void ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed, TServerSettings& serverSettings) {
        serverSettings.ProcessParsedOptions(parsed);
        serverSettings.SetEnableCompression(true);
        serverSettings.SetClientTimeout(TDuration::Seconds(10));
    }

    THolder<TStatsInitializer> GetStatsInitializer() override {
        return MakeHolder<TSubscriptionStoreStatsInitializer>();
    }

private:
    NYasm::NCommon::TFastConfig FastConfig;
    TSubscriptionStoreHandlersCollection HttpHandlers;
};

int main(int argc, const char** argv) {
    return RunFromMain<TSubscriptionStore, TServerSettings, TThreadedLoggerFactory>(argc, argv);
}
