<% set COMMENT = "!!!DO NOT EDIT IN UI!!! Edit via arcadia/infra/yasm/tools/dashboards" %>

<% set service_groups = [
    {
        "name": "Aggregators (lines)",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_LINES_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "MAN_YASM_LINES_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "MAN_YASM_LINES_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "MAN_YASM_LINES_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "MAN_YASM_LINES_DUMPER", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_LINES_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "SAS_YASM_LINES_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "SAS_YASM_LINES_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "SAS_YASM_LINES_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "SAS_YASM_LINES_DUMPER", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "VLA",
                "static": True,
                "master_group": "VLA_YASM_LINES_SRV_NEW",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "VLA_YASM_LINES_SRV_NEW", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "VLA_YASM_LINES_TSDB_NEW", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "VLA_YASM_LINES_HSRV_NEW", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "VLA_YASM_LINES_DUMPER_NEW", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "IVA",
                "static": True,
                "master_group": "MSK_IVA_YASM_LINES_SRV_NEW",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "MSK_IVA_YASM_LINES_SRV_NEW", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "MSK_IVA_YASM_LINES_TSDB_NEW", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "MSK_IVA_YASM_LINES_HSRV_NEW", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "MSK_IVA_YASM_LINES_DUMPER_NEW", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "MYT",
                "static": True,
                "master_group": "MSK_MYT_YASM_LINES_SRV_NEW",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "MSK_MYT_YASM_LINES_SRV_NEW", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "MSK_MYT_YASM_LINES_TSDB_NEW", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "MSK_MYT_YASM_LINES_HSRV_NEW", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "MSK_MYT_YASM_LINES_DUMPER_NEW", "itype": "yasmdumper" },
                ]
            },
        ],
    },
    {
        "name": "Aggregators (misc)",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_PRODUCTION_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "MAN_YASM_PRODUCTION_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "MAN_YASM_PRODUCTION_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "MAN_YASM_PRODUCTION_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "MAN_YASM_PRODUCTION_DUMPER", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "SAS_YASM_PRODUCTION_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "SAS_YASM_PRODUCTION_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "SAS_YASM_PRODUCTION_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "SAS_YASM_PRODUCTION_DUMPER", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "VLA",
                "static": True,
                "master_group": "VLA_YASM_PRODUCTION_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "VLA_YASM_PRODUCTION_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "VLA_YASM_PRODUCTION_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "VLA_YASM_PRODUCTION_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "VLA_YASM_PRODUCTION_DUMPER", "itype": "yasmdumper" },
                ]
            },
            {
                "name": "MSK",
                "static": True,
                "master_group": "MSK_YASM_PRODUCTION_SRV",
                "itype": "yasmsrv",
                "services": [
                    { "name": "yasmserver", "group": "MSK_YASM_PRODUCTION_SRV", "itype": "yasmsrv" },
                    { "name": "TSDB", "group": "MSK_YASM_PRODUCTION_TSDB", "itype": "yasmtsdb" },
                    { "name": "hserver", "group": "MSK_YASM_PRODUCTION_HSRV", "itype": "yasmhserver" },
                    { "name": "Dumper", "group": "MSK_YASM_PRODUCTION_DUMPER", "itype": "yasmdumper" },
                ]
            },
        ],
    },
    {
        "name": "Rtfront",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_PRODUCTION_RTFRONT",
                "itype": "rtfront",
                "services": [
                    { "name": "rtfront", "group": "MAN_YASM_PRODUCTION_RTFRONT", "itype": "rtfront" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_RTFRONT",
                "itype": "rtfront",
                "services": [
                    { "name": "rtfront", "group": "SAS_YASM_PRODUCTION_RTFRONT", "itype": "rtfront" },
                ]
            },
            {
                "name": "VLA",
                "static": False,
                "master_group": "VLA_YASM_PRODUCTION_RTFRONT",
                "itype": "rtfront",
                "services": [
                    { "name": "rtfront", "group": "VLA_YASM_PRODUCTION_RTFRONT", "itype": "rtfront" },
                ]
            },
        ]
    },
    {
        "name": "Afront",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_AFRONT_PROD",
                "itype": "yasmafront",
                "services": [
                    { "name": "afront", "group": "MAN_YASM_AFRONT_PROD", "itype": "yasmafront" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_AFRONT_PROD",
                "itype": "yasmafront",
                "services": [
                    { "name": "afront", "group": "SAS_YASM_AFRONT_PROD", "itype": "yasmafront" },
                ]
            },
            {
                "name": "VLA",
                "static": False,
                "master_group": "VLA_YASM_AFRONT_PROD",
                "itype": "yasmafront",
                "services": [
                    { "name": "afront", "group": "VLA_YASM_AFRONT_PROD", "itype": "yasmafront" },
                ]
            },
        ]
    },
    {
        "name": "Alertserver",
        "dcs": [
            {
                "name": "MAN",
                "static": False,
                "master_group": "MAN_YASM_PRODUCTION_ASRV",
                "itype": "yasmalertserver",
                "services": [
                    { "name": "alertserver", "group": "MAN_YASM_PRODUCTION_ASRV", "itype": "yasmalertserver" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_ASRV",
                "itype": "yasmalertserver",
                "services": [
                    { "name": "alertserver", "group": "SAS_YASM_PRODUCTION_ASRV", "itype": "yasmalertserver" },
                ]
            },
            {
                "name": "VLA",
                "static": False,
                "master_group": "VLA_YASM_PRODUCTION_ASRV",
                "itype": "yasmalertserver",
                "services": [
                    { "name": "alertserver", "group": "VLA_YASM_PRODUCTION_ASRV", "itype": "yasmalertserver" },
                ]
            },
        ]
    },
    {
        "name": "Collector/Clickhouse",
        "dcs": [
            {
                "name": "MAN",
                "static": False,
                "master_group": "MAN_YASM_PRODUCTION_COLLECTOR",
                "itype": "yasmcollector",
                "services": [
                    { "name": "collector", "group": "MAN_YASM_PRODUCTION_COLLECTOR", "itype": "yasmcollector" },
                    { "name": "clickhouse", "group": "MAN_YASM_PRODUCTION_CLICKHOUSE_NEW", "itype": "clickhouse" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_COLLECTOR",
                "itype": "yasmcollector",
                "services": [
                    { "name": "collector", "group": "SAS_YASM_PRODUCTION_COLLECTOR", "itype": "yasmcollector" },
                    { "name": "clickhouse", "group": "SAS_YASM_PRODUCTION_CLICKHOUSE_NEW", "itype": "clickhouse" },
                ]
            },
            {
                "name": "VLA",
                "static": False,
                "master_group": "SAS_YASM_PRODUCTION_COLLECTOR",
                "itype": "yasmcollector",
                "services": [
                    { "name": "collector", "group": "VLA_YASM_PRODUCTION_COLLECTOR", "itype": "yasmcollector" },
                    { "name": "clickhouse", "group": "VLA_YASM_PRODUCTION_CLICKHOUSE_NEW", "itype": "clickhouse" },
                ]
            },
        ],
    },
    {
        "name": "Ambry/Mongo/Histfront/Nginx",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_PRODUCTION_AMBRY",
                "itype": "yasmambry",
                "services": [
                    { "name": "ambry", "group": "MAN_YASM_PRODUCTION_AMBRY", "itype": "yasmambry" },
                    { "name": "mongo", "group": "MAN_YASM_PRODUCTION_MONGO", "itype": "mongo3" },
                    { "name": "histfront", "group": "MAN_YASM_PRODUCTION_HISTFRONT", "itype": "histfront" },
                    { "name": "nginx", "group": "MAN_YASM_PRODUCTION_NGINX_NEW", "itype": "yasmui" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_AMBRY",
                "itype": "yasmambry",
                "services": [
                    { "name": "ambry", "group": "SAS_YASM_PRODUCTION_AMBRY", "itype": "yasmambry" },
                    { "name": "mongo", "group": "SAS_YASM_PRODUCTION_MONGO", "itype": "mongo3" },
                    { "name": "histfront", "group": "SAS_YASM_PRODUCTION_HISTFRONT", "itype": "histfront" },
                    { "name": "nginx", "group": "SAS_YASM_PRODUCTION_NGINX_NEW", "itype": "yasmui" },
                ]
            },
            {
                "name": "VLA",
                "static": True,
                "master_group": "VLA_YASM_PRODUCTION_AMBRY",
                "itype": "yasmambry",
                "services": [
                    { "name": "ambry", "group": "VLA_YASM_PRODUCTION_AMBRY", "itype": "yasmambry" },
                    { "name": "mongo", "group": "VLA_YASM_PRODUCTION_MONGO", "itype": "mongo3" },
                    { "name": "histfront", "group": "VLA_YASM_PRODUCTION_HISTFRONT", "itype": "histfront" },
                    { "name": "nginx", "group": "VLA_YASM_PRODUCTION_NGINX_NEW", "itype": "yasmui" },
                ]
            },
        ],
    },
    {
        "name": "Snapshooter",
        "dcs": [
            {
                "name": "MAN",
                "static": True,
                "master_group": "MAN_YASM_PRODUCTION_SNAP",
                "itype": "yasmsnapshooter",
                "services": [
                    { "name": "snapshooter", "group": "MAN_YASM_PRODUCTION_SNAP", "itype": "yasmsnapshooter" },
                    { "name": "snapshooter_nginx", "group": "MAN_YASM_PRODUCTION_SNAP_NGINX", "itype": "yasmsnapshooter" },
                ]
            },
            {
                "name": "SAS",
                "static": True,
                "master_group": "SAS_YASM_PRODUCTION_SNAP",
                "itype": "yasmsnapshooter",
                "services": [
                    { "name": "snapshooter", "group": "SAS_YASM_PRODUCTION_SNAP", "itype": "yasmsnapshooter" },
                    { "name": "snapshooter_nginx", "group": "SAS_YASM_PRODUCTION_SNAP_NGINX", "itype": "yasmsnapshooter" },
                ]
            },
        ]
    },

]
%>

{
    "abc": "golovan",
    "user": "andreyst",
    "type": "panel",
    "title": "YASM capacity — Memory",
    "charts": [
        <% set row = 0 %>
        <% for service_group in service_groups -%>
            <% set row = row + 1 %>
            {
                "type": "text",
                "width": 5,
                "height": 1,
                "row": << row >>,
                "col": 1,
                "links": "",
                "text": "<< service_group["name"] >> network used, bytes (less is good)"
            },
            <% set col = 0 %>
            <% set row2 = row %>
            <% for dc in service_group["dcs"] -%>
                <% set col = col + 1 %>
                <% for service in dc["services"] -%>
                    <% set row2 = row2 + 1 %>
                    {
                        "type": "graphic",
                        "width": 1,
                        "height": 1,
                        "row": << row2 >>,
                        "col": << col >>,
                        "links": "",
                        "title": "<< service["name"] >> << dc["name"] >> network used, bytes",
                        "signals": [
                            {
                                "tag": "itype=<<service["itype"]>>;ctype=prod;gencfg=<<service["group"]>>",
                                "host": "ASEARCH",
                                "name": "div(netstat-ibytes_summ, div(normal(), 5))"
                            }
                        ],
                        "consts": [{"value": 0.6, "color": "red"}, {"value": 0, "color": "green"}]
                    },
                <% endfor -%>
            <% endfor -%>
            <% set row = row + service_group["dcs"][0]["services"]|length %>
        <% endfor -%>
    ]
}
