from libcpp cimport bool as bool_t

from util.generic.string cimport TString
from util.generic.vector cimport TVector

cdef extern from "<util/generic/ptr.h>" nogil:
    cdef cppclass TAtomicSharedPtr[T]:
        TAtomicSharedPtr()
        T* Get()


cdef extern from "library/cpp/unistat/types.h" namespace "EAggregationType":
    cdef enum EAggregationType "EAggregationType":
        Average,
        HostHistogram,
        Max,
        Min,
        Sum,
        SumOne,
        LastValue


cdef extern from "library/cpp/unistat/unistat.h" namespace "NUnistat" nogil:
    cdef cppclass IHole:
        IHole()

        void PushSignal(double signal)
        void ResetSignal()

    cdef struct TPriority:
        TPriority(int priority)

    cdef struct TStartValue:
        TStartValue(double startValue)


cdef extern from "library/cpp/unistat/unistat.h" nogil:
    cdef cppclass TUnistat:
        TUnistat()

        @staticmethod
        TUnistat& Instance();

        bool_t PushSignalUnsafe(const TString& holename, double signal)

        TString CreateJsonDump(int level, bool_t allHoles)
        TString CreateInfoDump(int level)

        void Reset()
        void ResetSignals()

        TAtomicSharedPtr[IHole] DrillFloatHole(const TString& name,
                                               const TString& suffix,
                                               TPriority priority,
                                               TStartValue startValue,
                                               EAggregationType aggrType,
                                               bool_t alwaysVisible)

        TAtomicSharedPtr[IHole] DrillHistogramHole(const TString& name,
                                                   const TString& suffix,
                                                   TPriority priority,
                                                   const TVector[double]& intervals,
                                                   EAggregationType aggrType,
                                                   bool_t alwaysVisible)


cdef extern from "infra/yasm/unistat/trampoline.h" nogil:
    TPriority CreatePriority(int priority)
    TStartValue CreateValue(double value)
