                                               _
       __  ______ __________ ___  ____ _____  (_)
      / / / / __ `/ ___/ __ `__ \/ __ `/ __ \/ /
     / /_/ / /_/ (__  ) / / / / / /_/ / /_/ / /
     \__, /\__,_/____/_/ /_/ /_/\__,_/ .___/_/
    /____/                          /_/

Данный модуль реализует запрос получения исторических и RT данных из Golovan.

Типичный пример использования
-----------------------------

## Единичное получение данных

```python
>>> import logging
>>> from time import time
>>> from yasmapi import GolovanRequest
>>> host = "ASEARCH"
>>> logging.basicConfig()  # Инициализируем root логгер
>>> period = 300  # Пятиминутные данные
>>> et = time() - period * 5  # Интересуют последние гарантированно агрегированные точки
>>> st = et - period * 3  # Три последние точки
>>> signals = [
..."itype=common:havg(cpu-us_hgram)"
... ]
>>> for timestamp, values in GolovanRequest(host, period, st, et, signals):
... print timestamp, values
...
1412841600 {'itype=common:havg(cpu-us_hgram)': 19.108171039779478}
1412841900 {'itype=common:havg(cpu-us_hgram)': 18.709824913928905}
1412842200 {'itype=common:havg(cpu-us_hgram)': 18.604999055358412}
```

## Получение realtime данных в бесконечном цикле

```python
>>> import logging
>>> from yasmapi import RtGolovanRequest
>>> logging.basicConfig()
>>> host = "ASEARCH"
>>> tags = "itype=common"
>>> signals = ["havg(cpu-us_hgram)"]
>>> for point in RtGolovanRequest({host: {tags: signals}}):
... print point.ts, point.values[host][tags]
...
...
1463562035 {u'havg(cpu-us_hgram)': 24.490658256028667}
1463562040 {u'havg(cpu-us_hgram)': 24.544982687419513}
1463562045 {u'havg(cpu-us_hgram)': 24.588835890673014}
1463562050 {u'havg(cpu-us_hgram)': 24.224413881684836}
```

Периоды
-------

В Головане существуют несколько стандартных периодов:

* 5 — Пятисекундные данные
* 300 — Пятиминутные данные, расчитываются раз в 25 минут
* 3600 — Часовые данные, расчитываются раз в час
* 10800 — Трёхчасовые данные, расчитываются раз в три часа
* 21600 — Шестичасовые данные, расчитываются раз в шесть часов
* 43200 — Двенадцатичасовые данные, расчитываются раз в двенадцать часов
* 86400 — Суточные данные, расчитываются раз в сутки

Использование любых других периодов приведёт к отсутствию ответа. Не стоит запрашивать
интервалы, правый край которых больше чем (now - время расчёта прериода), так как,
вероятнее всего, этих данных ещё нет.

Сигналы
-------

Сигналы записываются в полностью квалифицированной форме, то есть: `<тег>:<модуль>-<сигнал>_<суффикс>`,
где тег может быть любой комбинацией тегов, например `itype=mmeta;ctype=prestable;prj=imgs-main;geo=sas;tier=yandsearch`
или `itype=mmeta`. Тэг `itype` является обязательным. Суффикс определяет тип сигнала и способ его агрегации. Подробности
можно найти на https://wiki.yandex-team.ru/golovan/aggregation-types/.

Логирование
-------
Библиотека логирует ошибки, возникшие при работе с API.
Импортирующее приложение должно инициализировать корневой логгер перед использованием библиотеки.
В противном случае логирование не будет работать, сообщая в stderr:

`No handlers could be found for logger "infra.yasm.yasmapi.hist"`