#include <infra/yasm/zoom/components/aggregators/subscription_filter.h>

#include <library/cpp/testing/benchmark/bench.h>

using namespace NTags;
using namespace NZoom::NAggregators;
using namespace NZoom::NSignal;

TVector<TSignalName> ToSignalList(TVector<TStringBuf> signals) {
    TVector<TSignalName> result;
    for (const auto signal : signals) {
        result.emplace_back(signal);
    }
    return result;
}

Y_CPU_BENCHMARK(SubscriptionFilter_Match, iface) {
    TSubscriptionFilter filter;

    filter.Add(TRequestKey::FromString("itype=addrsupper;geo=sas"), ToSignalList({"first_signal", "third_signal"}));
    filter.Add(TRequestKey::FromString("itype=addrsupper;prj=addrs"), ToSignalList({"second_signal", "third_signal"}));
    filter.Add(TRequestKey::FromString("itype=addrsupper;ctype=prestable"), ToSignalList({"first_signal"}));
    filter.Add(TRequestKey::FromString("itype=addrsupper;ctype=prestable;prj=addrs;geo=sas"), ToSignalList({"third_signal"}));

    const auto instanceKey(TInstanceKey::FromNamed("addrsupper|ctype=prestable;geo=sas;prj=addrs|tier"));
    const auto signalList(ToSignalList({"first_signal", "second_signal"}));

    for (size_t i = 0; i < iface.Iterations(); i++) {
        Y_DO_NOT_OPTIMIZE_AWAY(filter.Match(instanceKey, signalList));
    }
}

Y_CPU_BENCHMARK(SubscriptionFilter_Add, iface) {
    TSubscriptionFilter filter;

    for (size_t i = 0; i < iface.Iterations(); i++) {
        TStringBuf tag;
        if (i % 5 == 0) {
            tag = TStringBuf("itype=addrsupper;geo=sas;prj=addrs");
        } else if (i % 3 == 0) {
            tag = TStringBuf("itype=addrsupper;geo=sas");
        } else if (i % 2 == 0) {
            tag = TStringBuf("itype=addrsupper;ctype=prestable");
        } else {
            tag = TStringBuf("itype=addrsupper;prj=addrs");
        }
        filter.Add(TRequestKey::FromString(tag),
                   ToSignalList({"first_signal", "second_signal", "third_signal"}));
    }
}
