#pragma once

#include "metrics.h"

#include <infra/yasm/zoom/components/containers/group.h>
#include <infra/yasm/zoom/components/record/record.h>

namespace NZoom {
    namespace NAggregators {
        struct ITagGroupContainerCallback {
            virtual ~ITagGroupContainerCallback() = default;

            virtual void SetObjectsCount(const size_t count);
            virtual void OnTagContainer(NTags::TInstanceKey key, const NZoom::NContainers::TGroupContainer& container) = 0;
        };

        class TGroupAggregator {
        private:
            using TInstanceMap = THashMap<NTags::TInstanceKey, NZoom::NContainers::TGroupContainer>;

            const NZoom::NYasmConf::TYasmConf& Conf;
            TInstanceMap Storage;

            NZoom::NContainers::TGroupContainer& Find(NTags::TInstanceKey instanceKey);

        public:
            TGroupAggregator(const NZoom::NYasmConf::TYasmConf& conf);

            void Mul(const NZoom::NRecord::TTaggedRecord& taggedRecord,
                     TTaggedMetricManager& metricManager);
            void Mul(NTags::TInstanceKey instanceKey,
                     const NZoom::NRecord::TRecord& record,
                     TTaggedMetricManager& metricManager);

            size_t Len() const noexcept;
            void Clean();
            void Clean(const TInstant explicitNow); // Debugging hook
            void Process(ITagGroupContainerCallback& callback) const;
        };
    }
}
