#include "group.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NTags;
using namespace NZoom::NAggregators;
using namespace NZoom::NYasmConf;
using namespace NZoom::NSignal;
using namespace NZoom::NValue;
using namespace NZoom::NRecord;

Y_UNIT_TEST_SUITE(TZoomTGroupAggregatorTest) {
    TTaggedRecord CreateRecord() {
        TVector <std::pair<TSignalName, TValue>> signalVec;
        signalVec.emplace_back(TString("portoinst-max_rss_gb_tvvv"), TValue(0.04380035400390625, 1));
        TRecord record(std::move(signalVec));

        TVector<std::pair<TInstanceKey, TRecord>> tagVec;
        tagVec.emplace_back(TInstanceKey::FromNamed("itype||tier"), std::move(record));
        return {std::move(tagVec)};
    }

    Y_UNIT_TEST(ContainerCleanup) {
        TYasmConf yasmConf = TYasmConf::FromString(TStringBuf("{\"conflist\": {\"common\": {\"signals\": {}, \"patterns\": {}, \"periods\": {}}}}"));

        TTaggedMetricManager metricManager;
        TGroupAggregator aggregator(yasmConf);

        TInstant now = TInstant::Now();
        TTaggedRecord record(CreateRecord());

        aggregator.Mul(record, metricManager);
        UNIT_ASSERT_VALUES_EQUAL(aggregator.Len(), 1);

        aggregator.Clean(now);
        UNIT_ASSERT_VALUES_EQUAL(aggregator.Len(), 1);

        aggregator.Clean(TInstant::Now() + TDuration::Seconds(120));
        UNIT_ASSERT_VALUES_EQUAL(aggregator.Len(), 0);
    }
}
